<?php
/**
 * PHPUnit test case for GenerationGapDaoGenerator
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-29
 */
require_once 'PHPUnit.php';
class GenerationGapDaoGeneratorTest extends PHPUnit_TestCase {

    var $GenerationGapDaoGenerator;

    function GenerationGapDaoGeneratorTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once '../peewee.config.php';
        require_once 'GenerationGapDaoGenerator.php';
        $this->GenerationGapDaoGenerator =& new GenerationGapDaoGenerator();
    }

    function tearDown()
    {
        unset($this->GenerationGapDaoGenerator);
    }

    function testcreateGenerationGapDao()
    {
        $result = $this->GenerationGapDaoGenerator->createGenerationGapDao("table_name", "suffix");
		$this->assertFalse(stristr($result, "<?"));
		$this->assertFalse(stristr($result, "?>"));
    }

    function testOutputRequireOnce()
    {
        $result = $this->GenerationGapDaoGenerator->createGenerationGapDao("table_name", "suffix");
		$this->assertTrue(stristr($result, "require_once \"TableNameDao.php\";"));
    }

    function testOutputClassDefinition()
    {
        $result = $this->GenerationGapDaoGenerator->createGenerationGapDao("table_name", "suffix");
		$this->assertTrue(stristr($result, "class TableNameDaosuffix extends TableNameDao{"));
    }

    function testOutputConstructor()
    {
        $result = $this->GenerationGapDaoGenerator->createGenerationGapDao("table_name", "suffix");
		$this->assertTrue(stristr($result, "function TableNameDaosuffix()"));
    }
}
// Running the test.
//$suite  = new PHPUnit_TestSuite('GenerationGapDaoGeneratorTest');
//$result = PHPUnit::run($suite);
//echo $result->toHtml();
?>
