<?php
require_once ROOT_DIR . "util/StringUtility.php";

/**
 * GenerationGapDtoGenerator
 *
 * <code>
 * $a = new GenerationGapDtoGenerator();
 * $a->createGenerationGapDto(...);
 * </code>
 *
 * @package    peewee.logic
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class GenerationGapDtoGenerator{
    /**
     * generate DTO Inheritance  class
     *
     * @param  String $tableName tablename
     * @return String ggdtosourcecode
     * @access public
     */
    function createGenerationGapDto($tableName, $generationGapSuffix){
        $stringUtility = new StringUtility();
        $tableClassName = $stringUtility->getClassName($tableName);
        if(empty($generationGapSuffix)){
            print "error";
            return;
        }
$dto= <<< DTO_END
require_once "{$tableClassName}Dto.php";

/**
 * {$tableName} DTO Inheritance  Class
 *
 * @package
 * @author
 * @license
 * @version
 */
class {$tableClassName}Dto{$generationGapSuffix} extends {$tableClassName}Dto{
    /**
     * default constructor
     *
     * @access public
     */
    function {$tableClassName}Dto{$generationGapSuffix}(){
        parent::{$tableClassName}Dto();
    }
}
DTO_END;
            return $dto;
    }
}
?>