<?php
/**
 * PHPUnit test case for GenerationGapDtoGenerator
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-29
 */
require_once 'PHPUnit.php';
class GenerationGapDtoGeneratorTest extends PHPUnit_TestCase {

    var $GenerationGapDtoGenerator;

    function GenerationGapDtoGeneratorTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once '../peewee.config.php';
        require_once 'GenerationGapDtoGenerator.php';
        $this->GenerationGapDtoGenerator =& new GenerationGapDtoGenerator(PARAM);
    }

    function tearDown()
    {
        unset($this->GenerationGapDtoGenerator);
    }

    function testcreateGenerationGapDto()
    {
        $result   = $this->GenerationGapDtoGenerator->createGenerationGapDto("table_name", "suffix");
		$this->assertFalse(stristr($result, "<?"));
		$this->assertFalse(stristr($result, "?>"));
    }

    function testOutputRequireOnce()
    {
        $result   = $this->GenerationGapDtoGenerator->createGenerationGapDto("table_name", "suffix");
		$this->assertTrue(stristr($result, "require_once \"TableNameDto.php\";"));
    }

    function testOutputClassDefinition()
    {
        $result   = $this->GenerationGapDtoGenerator->createGenerationGapDto("table_name", "suffix");
		$this->assertTrue(stristr($result, "class TableNameDtosuffix extends TableNameDto{"));
    }

    function testOutputConstructor()
    {
        $result   = $this->GenerationGapDtoGenerator->createGenerationGapDto("table_name", "suffix");
		$this->assertTrue(stristr($result, "function TableNameDtosuffix(){"));
    }
}
// Running the test.
//$suite  = new PHPUnit_TestSuite('GenerationGapDtoGeneratorTest');
//$result = PHPUnit::run($suite);
//echo $result->toHtml();
?>
