<?php
require_once ROOT_DIR . "dao/TableDefinitionDao.php";
require_once ROOT_DIR . "logic/BaseDaoGenerator.php";
require_once ROOT_DIR . "logic/DtoGenerator.php";
require_once ROOT_DIR . "logic/GenerationGapDtoGenerator.php";
require_once ROOT_DIR . "logic/DaoGenerator.php";
require_once ROOT_DIR . "logic/GenerationGapDaoGenerator.php";
require_once ROOT_DIR . "util/FileUtility.php";
require_once ROOT_DIR . "util/StringUtility.php";
require_once ROOT_DIR . ADODB_INC_PATH;

// facade

/**
 * main class of Peewee
 *
 * Here is an example:
 *
 * <code>
 * <?php
 * require_once 'Peewee.php';
 * 
 * $peewee = new Peewee();
 * $peewee->autoCreate();
 * ?>
 * </code>
 *
 * @package    peewee
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class Peewee{
    /**
     * @var    String
     * @access private
     */
    var $adodbIncPath = null;

    /**
     * @var    String
     * @access private
     */
    var $dsn = null;

    /**
     * default constructor
     *
     * @param $adodbIncPath Adodb Include Path
     * @param $dsn DataSourceName
     * @access public
     */
    function PeeWee($adodbIncPath, $dsn){
        $this->adodbIncPath = $adodbIncPath;
        $this->dsn = $dsn;
    }

    /**
     * create all table's dto and dao
     *
     * @access public
     */
    function autoCreate(){
        $fileUtility = new FileUtility();
        $stringUtility = new StringUtility();
        $tableDefinitionDao = new TableDefinitionDao($this->dsn);

        $tableNameArray = $tableDefinitionDao->getTableNameList();
        $fileNameArray = array();
        $generationGapSuffix = GENERATIONGAP_SUFFIX;

        if(USE_BASE_CLASS){
            $baseDaoGenerator = new BaseDaoGenerator($this->adodbIncPath, $this->dsn);
            $baseDao = $baseDaoGenerator->createBaseDaoClass();
            $fileUtility->writePhpFile(OUTPUT_DIR . "BaseDao", $baseDao);
            $fileNameArray[] = "BaseDao";
        }

        foreach($tableNameArray as $tableName){
            $className = $stringUtility->getClassName($tableName);
            $columnList = $tableDefinitionDao->getColumnList($tableName);
            $primaryKeyList = $tableDefinitionDao->getPrimaryKeyList($tableName);

            $dtoGenerator = new DtoGenerator();
            $dto = $dtoGenerator->createDto($tableName, $columnList);

            $fileUtility->writePhpFile(OUTPUT_DIR . $className . "Dto", $dto);
            $fileNameArray[] = $className . "Dto";

            if(USE_GENERATIONGAP){
                $generationGapDtoGenerator = new GenerationGapDtoGenerator();
                $dtoext = null;
                $dtoext = $generationGapDtoGenerator->createGenerationGapDto($tableName, $generationGapSuffix);
                $fileUtility->writePhpFile(OUTPUT_DIR . $className . "Dto" . $generationGapSuffix, $dtoext);
                $fileNameArray[] = $className . "Dto" . $generationGapSuffix;

                $generationGapDaoGenerator = new GenerationGapDaoGenerator();
                $daoext = null;
                $daoext = $generationGapDaoGenerator->createGenerationGapDao($tableName, $generationGapSuffix);
                $fileUtility->writePhpFile(OUTPUT_DIR . $className . "Dao" . $generationGapSuffix, $daoext);
                $fileNameArray[] = $className . "Dao" . $generationGapSuffix;
            }

            $daoGenerator = new DaoGenerator($this->adodbIncPath, $this->dsn);
            if(USE_BASE_CLASS){
                $dao = $daoGenerator->createDao($tableName, $columnList, $primaryKeyList[0], "BaseDao");
            }else{
                $dao = $daoGenerator->createDao($tableName, $columnList, $primaryKeyList[0]);
            }
            $fileUtility->writePhpFile(OUTPUT_DIR . $className . "Dao", $dao);
            $fileNameArray[] = $className . "Dao";
        }
        return $fileNameArray;
    }
}
?>