<?php
/**
 * PHPUnit test case for FileUtility
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-26
 */
require_once 'PHPUnit.php';
require_once "../peewee.config.php";

/**
 * FileUtility TestCase
 *
 * @package    peewee.test
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class FileUtilityTest extends PHPUnit_TestCase {

    var $FileUtility;

    function FileUtilityTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once ROOT_DIR . 'util/FileUtility.php';
        $this->FileUtility =& new FileUtility();
    }

    function tearDown()
    {
        unset($this->FileUtility);
    }

    function testwritePhpFile()
    {
		if(file_exists("FileUtiiltyTestSample.php")){
			unlink("FileUtiiltyTestSample.php");
		}
        $result   = $this->FileUtility->writePhpFile("FileUtiiltyTestSample", "print(time())", "");

        $this->assertTrue(file_exists("FileUtiiltyTestSample.php"));
		$lines = file("FileUtiiltyTestSample.php");
        $this->assertEquals($lines[0], "<?php\n");
        $this->assertEquals($lines[1], "print(time())?>\n");

		unlink("FileUtiiltyTestSample.php");
    }

}
?>
