<?php
/**
 * PHPUnit test case for StringUtility
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-26
 */
require_once 'PHPUnit.php';
require_once "../peewee.config.php";

/**
 * StringUtility TestCase
 *
 * @package    peewee.test
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class StringUtilityTest extends PHPUnit_TestCase {

    var $StringUtility;

    function StringUtilityTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once ROOT_DIR . 'util/StringUtility.php';
        $this->StringUtility =& new StringUtility();
    }

    function tearDown()
    {
        unset($this->StringUtility);
    }

    function testgetClassName()
    {
        $result   = $this->StringUtility->getClassName("aiueo");
        $expected = "Aiueo";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getClassName("4aiueo");
        $expected = "4aiueo";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getClassName("");
        $expected = "";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getClassName("set_user_name");
        $expected = "SetUserName";
        $this->assertEquals($expected, $result);
    }

    function testgetVariableName()
    {
        $result   = $this->StringUtility->getVariableName("aiueo");
        $expected = "aiueo";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getVariableName("12345");
        $expected = "12345";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getVariableName("");
        $expected = "";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getVariableName("DATABASE");
        $expected = "dATABASE";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getVariableName("GetMyName");
        $expected = "getMyName";
        $this->assertEquals($expected, $result);

        $result   = $this->StringUtility->getVariableName("get_my_name");
        $expected = "getMyName";
        $this->assertEquals($expected, $result);
    }

}
?>
