package pencilbox.bijutsukan;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import pencilbox.common.core.BoardBase;
import pencilbox.util.ArrayUtil;


/**
 * upفvՖʃNX
 */
public class Board extends BoardBase {

	static final int NONUMBER_WALL = 5;
	static final int ILLUMINATION = -2;
	static final int NOILLUMINATION = -3;
	static final int UNKNOWN = -1;
	static final int OUTER = 6;

	private int[][] state;
	private int[][] illuminatedH;
	private int[][] illuminatedV;

	protected void setup() {
		super.setup();
		state = new int[rows()][cols()]; 
		illuminatedV = new int[rows()][cols()];
		illuminatedH = new int[rows()][cols()];
		ArrayUtil.initArrayInt2(state, UNKNOWN);
	}
	
	public void clearBoard() {
		super.clearBoard();
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (isFloor(r, c)) {
					setState(r,c,UNKNOWN);
				}
			}
		}
		initBoard();
	}

	public void initBoard() {
		initIlluminations();
	}
	/**
	 * ݂̏ƖzuƂɁCilluminatedV illuminatedHĐݒ肷
	 */
	void initIlluminations() {
		ArrayUtil.initArrayInt2(illuminatedV, 0);
		ArrayUtil.initArrayInt2(illuminatedH, 0);
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (isIllumination(r,c)) {
					illuminate(r, c, true);
				}
			}
		}
	}
	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}
	/**
	 * }X̏Ԃ擾 
	 * @param r sW
	 * @param c W
	 * @return 
	 */
	public int getState(int r, int c) {
		if (isOn(r,c)) return state[r][c];
		else return OUTER;
	}
	/**
	 * }X̏Ԃ݂̂ݒ肷
	 * @param r sW
	 * @param c W
	 * @param st 
	 */
	public void setState(int r, int c, int st) {
		state[r][c] = st;
	}
	/**
	 * ̃}Xǂǂ
	 * @param r sW
	 * @param c W
	 * @return ǂȂ true
	 */
	public boolean isWall(int r, int c){
		return state[r][c]>=0 && state[r][c]<=4 || state[r][c]==NONUMBER_WALL;
	}
	/**
	 * ̃}X̕ǂǂ
	 * @param r sW
	 * @param c W
	 * @return ǂȂ true
	 */
	public boolean isNumberedWall(int r, int c){
		return state[r][c]>=0 && state[r][c]<=4;
	}
	/**
	 * ̃}Xǂ̂Ȃ}Xǂ
	 * @param r sW
	 * @param c W
	 * @return ՓłǂłȂȂ true
	 */
	public boolean isFloor(int r, int c){
		return isOn(r,c) && (state[r][c] == UNKNOWN || state[r][c] == NOILLUMINATION || state[r][c] == ILLUMINATION);
	}
	/**
	 * ̃}XɏƖuĂ邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ƖuĂȂ true
	 */
	public boolean isIllumination(int r, int c){
		return isOn(r,c) && state[r][c] == ILLUMINATION;
	}
	/**
	 * ̃}X̏Ɩzu肩ǂ
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public boolean isUnknown(int r, int c) {
		return state[r][c] == UNKNOWN;
	}
	/**
	 * ̃}XƂ炳Ă邩
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public int getHorizIlluminated(int r, int c) {
		return illuminatedH[r][c];
	}
	/**
	 * ̃}XcƂ炳Ă邩
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public int getVertIlluminated(int r, int c) {
		return illuminatedV[r][c];
	}
	/**
	 * ̃}X̏̕ƖɂƂ炳Ă邩HHH
	 * @param r sW
	 * @param c W
	 * @return Ȃ true
	 */
	public boolean isMultiIlluminated(int r, int c) {
		return illuminatedV[r][c]>1 || illuminatedH[r][c] > 1;
	}
	/**
	 * }XƂ炳Ă邩C܂肻̃}X̏㉺EɏƖ邩𒲂ׂ
	 * @param r sW
	 * @param c W
	 * @return Ƃ炳Ă true
	 */
	public boolean isIlluminated(int r, int c) {
			return (illuminatedV[r][c] > 0 || illuminatedH[r][c] > 0);
	}
	/**
	 * }X̏ƖzuύXꂽꍇɁC㉺ĚXV
	 * @param r0 ƖzuύXꂽ}X̍sW
	 * @param c0 ƖzuύXꂽ}X̗W
	 * @param on ƖzuꂽƂɂ true, 菜ꂽƂ false 
	 */
	private void illuminate(int r0, int c0, boolean on) {
		int k = on ? 1 : -1;
		int r = r0;
		int c = c0;
		while (isFloor(r, c)) {
			r--;
		}
		r++;
		while (isFloor(r, c)) {
			illuminatedV[r][c] += k;
			r++;
		}
		r = r0;
		while(isFloor(r,c)) {
			c--;
		}
		c++;
		while(isFloor(r,c)) {
			illuminatedH[r][c] += k;
			c++;
		}
	}
	/**
	 * }X̏Ԃݒ肷
	 * }X̌XV
	 * @param r sW
	 * @param c W
	 * @param st 
	 */
	public void changeState(int r, int c, int st) {
		if (st == ILLUMINATION && state[r][c] != ILLUMINATION)
			illuminate(r, c, true);
		else if (state[r][c] == ILLUMINATION && st != ILLUMINATION)
			illuminate(r, c, false);
		setState(r, c, st);
	}
	/**
	 * }X̏Ԃw肵ԂɕύXCύXAhDXi[ɒʒm
	 * @param r sW
	 * @param c W
	 * @param st ύX̏
	 */
	public void changeStateA(int r, int c, int st) {
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r,c,getState(r,c),st)));
		changeState(r, c, st);
	}
	/**
	 * }X̏Ԃ   st Ɛ؂ւ
	 * @param r sW
	 * @param c W
	 * @param st ؂ւ
	 */
	public void toggleState(int r, int c, int st) {
		if (isWall(r,c))
			return;
		if (getState(r,c) == st) {
			changeStateA(r, c, UNKNOWN);
		} else {
			changeStateA(r, c, st);
		}
	}

	/**
	 * אڂS}X̏Ɩ𒲂ׂ
	 * @param r sW
	 * @param c W
	 * @return אڂS}X̏Ɩ
	 */
	public int countAdjacentIllumination(int r, int c) {
		int count = 0;
		if (isIllumination(r-1,c)) count++;
		if (isIllumination(r+1,c)) count++;
		if (isIllumination(r,c-1)) count++;
		if (isIllumination(r,c+1)) count++;
		return count;
	}
	/**
	 * ǂɗאڂ4}X̏Ɩǂ𒲍
	 * @param r sW
	 * @param c W
	 * @return ƖƓȂC1, 
	 * ƖȂ -1, 
	 * Ɩ菬Ȃ 0
	 */
	public int checkAdjacentIllumination(int r, int c) {
		int nIllumination = countAdjacentIllumination(r,c);
		int number = getState(r,c);
		if (nIllumination > number) {
			return -1;
		} else if (nIllumination == number) {
			return 1;
		} else if (nIllumination < number) {
			return 0;
		}
		return 0;
	}

	public int checkAnswerCode() {
		int result = 0;
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (!isWall(r,c)) {
					if (isMultiIlluminated(r,c)) {
						result |= 1;
					}
					else if (!isIlluminated(r,c)) {
						result |= 2;
					}
				}
				else if (isNumberedWall(r,c)) {
					if (countAdjacentIllumination(r,c) > getState(r,c)) {
						result |= 4;
					}
					else if (countAdjacentIllumination(r,c) < getState(r,c)) {
						result |= 8;
					}
				}
			}
		}
		return result;
	}
	
	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result==0)
			return BoardBase.COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result&1) == 1)
			message.append(ERR_MULTI_ILLUMINATION);
		if ((result&2) == 2)
			message.append(YET_NOT_ILLUMINATED);
		if ((result&4) == 4 || (result&8) == 8)
			message.append(ERR_WRONG_NUMBER);
		return message.toString();
	}

	static final String ERR_MULTI_ILLUMINATION = "̏Ɩ̂񂪂\n";
	static final String YET_NOT_ILLUMINATED = "Ƃ炳ĂȂ}X\n";
	static final String ERR_WRONG_NUMBER =  "Ɩ̍ĂȂ\n";

	
  /**
   * P̑\NX
   * UNDO, REDO ł̕ҏW̒PʂƂȂ
   */
   class Step extends AbstractUndoableEdit {

	  private int row;
	  private int col;
	  private int before;
	  private int after;
	  /**
	   * RXgN^
	   * @param r ύXꂽ}X̍sW
	   * @param c ύXꂽ}X̗W
	   * @param b ύXȌ
	   * @param a ύX̏
	   */
	  public Step(int r, int c, int b, int a) {
		  super();
		  row = r;
		  col = c;
		  before = b;
		  after = a;
	  }
	  public void undo() throws CannotUndoException {
		  super.undo();
		  changeState(row, col, before);
	  }
	  public void redo() throws CannotRedoException {
		  super.redo();
		  changeState(row, col, after);
	  }
	  
   }

}
