package pencilbox.common.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/**
 * ʃj[NX
 */
public class MenuBase {

	private JMenu fileMenu;
	private JMenu editMenu;
	private JMenu viewMenu;
	private JMenu helpMenu;
	
	private JMenuItem newBoardItem;
	private JMenuItem openItem;
	private JMenuItem coloseAndOpenItem;
	private JMenuItem saveItem;
	private JMenuItem saveImageItem;
	private JMenuItem copyImageItem;
	private JMenuItem printItem;
	private JMenuItem propertyItem;
	private JMenuItem closeItem;
	private JMenuItem quiteItem;
	private JMenuItem aboutItem;
	private JMenuItem clearItem;
	private JMenuItem undoItem;
	private JMenuItem redoItem;
	private JMenuItem undoAllItem;
	private JMenuItem redoAllItem;
	private JMenuItem palybackItem;
	private JMenuItem checkAnswerItem;
	private JMenuItem renewColorItem;
	private JMenuItem cursorItem;
	private ButtonGroup modeGroup;
	private JMenuItem problemEditModeItem;
	private JMenuItem answerModeItem;

	private JMenu colorMenu;
	private JMenu rotationMenu;
	private ButtonGroup rotationGroup;
	private JMenu displaySizeMenu;
	private ButtonGroup displaySizeGroup;
	private JMenu gridStyleMenu;
	private ButtonGroup gridStyleGroup;

	private Frame frame;
	private MenuCommand command;
	private PanelEventHandler panel;

	/**
	 * MenuNX̏ŁCMenuCX^XɎgp
	 * @param command ֘AtMenuCommand
	 * @param frame ֘AtFrame
	 * @param panel ֘AtPanel
	 */
	public void setup(MenuCommand command, Frame frame, PanelEventHandler panel) {
		this.frame = frame;
		this.command = command;
		this.panel = panel;
		buildCommonMenu();
		buildIndividualMenu();
		setAccelerators();
	}

	/**
	 * @return Returns the panel.
	 */
	protected PanelEventHandler getPanelBase() {
		return panel;
	}

	/**
	 * ʃj[쐬B
	 */
	protected void buildCommonMenu() {
		buildFileMenu();
		buiildEditMenu();
		buildViewMenu();
		buildHelpMenu();

		JMenuBar jMenuBar = frame.getJMenuBar();
		jMenuBar.add(fileMenu);
		jMenuBar.add(editMenu);
		jMenuBar.add(viewMenu);
		jMenuBar.add(helpMenu);
	}

	/**
	 * X̃pYpj[쐬B 
	 * eTuNXŃI[o[ChB
	 */
	protected void buildIndividualMenu() {
	}

	/**
	 * [t@C]j[쐬
	 */
	protected void buildFileMenu() {
		fileMenu = makeJMenu("t@C(F)", 'F');
		fileMenu.add(newBoardItem = makeCommandMenuItem("VK쐬(N)...", 'N'));
		fileMenu.add(openItem = makeCommandMenuItem("J(O)...", 'O'));
		fileMenu.add(coloseAndOpenItem = makeCommandMenuItem("ĊJ(L)...", 'L'));
		fileMenu.add(saveItem = makeCommandMenuItem("ۑ(S)...", 'S'));
		fileMenu.addSeparator();
		fileMenu.add(saveImageItem = makeCommandMenuItem("摜ۑ(I)...", 'I'));
		fileMenu.add(copyImageItem = makeCommandMenuItem("摜Rs[(M)", 'M'));
		fileMenu.add(printItem = makeCommandMenuItem("(P)...", 'P'));
		fileMenu.addSeparator();
		fileMenu.add(propertyItem = makeCommandMenuItem("vpeB(T)", 'T'));
		fileMenu.addSeparator();
		fileMenu.add(closeItem = makeCommandMenuItem("(C)", 'C'));
		fileMenu.add(quiteItem = makeCommandMenuItem("I(Q)", 'Q'));
	}

	/**
	 * [ҏW]j[쐬
	 */
	protected void buiildEditMenu() {
		editMenu = makeJMenu("ҏW(E)", 'E');
		editMenu.add(answerModeItem = makeCommandRadioButtonMenuItem("𓚃[h(A)", 'A'));
		editMenu.add(problemEditModeItem = makeCommandRadioButtonMenuItem("̓[h(E)", 'E'));
		editMenu.addSeparator();
		editMenu.add(clearItem = makeCommandMenuItem("𓚏(C)", 'C'));
		editMenu.addSeparator();
		editMenu.add(undoItem = makeCommandMenuItem("ɖ߂(U)", 'U'));
		editMenu.add(redoItem = makeCommandMenuItem("蒼(R)", 'R'));
		// editMenu.add(undoAllItem = makeCommandMenuItem("ŏ܂Ŗ߂(F)", 'F'));
		// editMenu.add(redoAllItem = makeCommandMenuItem("Ō܂Ői߂(L)", 'L'));
		editMenu.add(palybackItem = makeCommandMenuItem("Đ(P)", 'P'));
		editMenu.addSeparator();
		editMenu.add(checkAnswerItem = makeCommandMenuItem("(H)", 'H'));
		editMenu.addSeparator();

		modeGroup = new ButtonGroup();
		modeGroup.add(answerModeItem);
		modeGroup.add(problemEditModeItem);
		editMenu.addMenuListener(new EditMenuListener());
	}

	/**
	 * [\]j[쐬
	 */
	protected void buildViewMenu() {
		viewMenu = makeJMenu("\(V)", 'V');
		buildRotationMenu();
		buildDisplaySizeMenu();
		buildGridStyleMenu();
		viewMenu.add(colorMenu = makeJMenu("F̐ݒ(L)", 'L'));
		viewMenu.add(rotationMenu);
		viewMenu.add(displaySizeMenu);
		viewMenu.addSeparator();
		viewMenu.addMenuListener(new ViewMenuListener());
	}

	/**
	 * [wv]j[쐬
	 */
	protected void buildHelpMenu() {
		helpMenu = makeJMenu("wv(H)", 'H');
		helpMenu.add(aboutItem = makeCommandMenuItem("PencilBoxɂ(A)", 'A'));
	}

	/**
	 * []E]]j[쐬
	 */
	protected void buildRotationMenu() {
		rotationMenu = makeJMenu("]E](R)", 'R');
		rotationGroup = new ButtonGroup();
		makeRotationItem(0, "0").setSelected(true);
		makeRotationItem(1, "90]");
		makeRotationItem(2, "180]");
		makeRotationItem(3, "E90]");
		makeRotationItem(4, "c");
		makeRotationItem(5, "E]");
		makeRotationItem(6, "180]+c");
		makeRotationItem(7, "㉺]");
	}
	/**
	 * []E]]j[쐬
	 * iJbNpbj
	 */
	protected void buildRotationMenu2() {
		rotationMenu = makeJMenu("]E](R)", 'R');
		rotationGroup = new ButtonGroup();
		makeRotationItem(0, "0").setSelected(true);
//		makeRotationItem(1, "90]");
//		makeRotationItem(2, "180]");
//		makeRotationItem(3, "E90]");
		makeRotationItem(4, "c");
//		makeRotationItem(5, "E]");
//		makeRotationItem(6, "180]+c");
//		makeRotationItem(7, "㉺]");
	}

	/**
	 * [\TCY]j[쐬
	 */
	void buildDisplaySizeMenu() {
		displaySizeMenu = makeJMenu("\TCY(S)", 'S');
		displaySizeGroup = new ButtonGroup();
		makeDisplaySizeItem(32, "");
		makeDisplaySizeItem(26, "").setSelected(true);
		makeDisplaySizeItem(20, "");
		makeDisplaySizeItem(14, "ɏ");
	}

	/**
	 * r\X^Cj[쐬B
	 * ̓IéCKvȂƂ̂݃TuNXŃI[o[Chč쐬
	 */
	protected void buildGridStyleMenu() {
		gridStyleMenu = makeJMenu("r\(G)", 'G');
		gridStyleGroup = new ButtonGroup();
	}

	/**
	 * [ҏW]j[Xi[NX
	 */
	protected class EditMenuListener implements MenuListener {
		/*
		 * ҏWj[J^C~OŁC KvɉăAhDChDj[L^ɂ
		 * ̓[h'/'L[ɂCj[pɕύXł̂ŁCj[JƂɌ݂̏Ԃ𒲂ׂčXVB
		 */
		public void menuSelected(MenuEvent evt) {
			undoItem.setEnabled(command.canUndo());
			redoItem.setEnabled(command.canRedo());
			// undoAllItem.setEnabled(command.canUndo());
			// redoAllItem.setEnabled(command.canRedo());
			palybackItem.setEnabled(command.canUndo() || command.canRedo());

			boolean b = getPanelBase().isProblemEditMode();
			problemEditModeItem.setSelected(b);
			answerModeItem.setSelected(!b);
		}

		/*
		 * j[炷ׂėLɖ߂
		 */
		public void menuDeselected(MenuEvent evt) {
			undoItem.setEnabled(true);
			redoItem.setEnabled(true);
			// undoAllItem.setEnabled(true);
			// redoAllItem.setEnabled(true);
			palybackItem.setEnabled(true);
		}

		public void menuCanceled(MenuEvent evt) {
		}
	}

	/**
	 * V[gJbgL[̈ꊇݒ
	 */
	private void setAccelerators() {
		newBoardItem.setAccelerator(
				KeyStroke.getKeyStroke('N',	KeyEvent.CTRL_MASK));
		openItem.setAccelerator(
				KeyStroke.getKeyStroke('O', KeyEvent.CTRL_MASK));
		coloseAndOpenItem.setAccelerator(
				KeyStroke.getKeyStroke('O',KeyEvent.CTRL_MASK | KeyEvent.SHIFT_MASK));
		saveItem.setAccelerator(
				KeyStroke.getKeyStroke('S', KeyEvent.CTRL_MASK));
		closeItem.setAccelerator(
				KeyStroke.getKeyStroke('W', KeyEvent.CTRL_MASK));
		undoItem.setAccelerator(
				KeyStroke.getKeyStroke('Z', KeyEvent.CTRL_MASK));
		redoItem.setAccelerator(
				KeyStroke.getKeyStroke('Y', KeyEvent.CTRL_MASK));
		answerModeItem.setAccelerator(
				KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
		problemEditModeItem.setAccelerator(
				KeyStroke.getKeyStroke(KeyEvent.VK_F2, KeyEvent.SHIFT_MASK));
		if (renewColorItem != null)
			renewColorItem.setAccelerator(
					KeyStroke.getKeyStroke(KeyEvent.VK_F6, 0));
	}

	/**
	 * [\]j[Xi[NX
	 */
	protected class ViewMenuListener implements MenuListener {
		/*
		 * sɂC̓[hł͔Ֆʉ]ȂƂƂ
		 */
		public void menuSelected(MenuEvent evt) {
			boolean b = getPanelBase().isProblemEditMode();
			rotationMenu.setEnabled(!b);
		}

		public void menuDeselected(MenuEvent evt) {
		}

		public void menuCanceled(MenuEvent evt) {
		}
	}

	/*
	 * ނ̃pYɋʂȃj[̍쐬ƒǉs
	 */
	/**
	 * [J[\]j[ڂ[\]j[̏ォ4ԖڂɒǉB
	 */
	protected void addCursorMenu() {
		cursorItem = makeJCheckBoxMenuItem("J[\(C)", 'C', panel.isCursorOn());
		cursorItem.addActionListener(commandAction);
		viewMenu.add(cursorItem, 3);
	}
	/**
	 * [F̍XV]j[ڂ[\]j[ɒǉB
	 */
	protected void addRenewColorMenu() {
		renewColorItem = makeCommandMenuItem("F̍XV(U)", 'U');
		viewMenu.add(renewColorItem);
	}
	/**
	 * [r\]j[[\]j[̏ォ4ԖڂɒǉB
	 */
	protected void addGridStyleMenu() {
		viewMenu.add(gridStyleMenu, 3);
	}

	/**
	 * w肵j[ڂ[\]j[ɒǉB
	 * @param item ǉ郁j[
	 */
	protected void addToViewMenu(JMenuItem item) {
		viewMenu.add(item);
	}

	/**
	 * u]E]vj[̃Tuj[ڂ쐬CO[vɒǉB
	 * @param n ݒ肷]Ԕԍ
	 * @param text j[\
	 * @return 쐬j[
	 */
	protected JRadioButtonMenuItem makeRotationItem(final int n, String text) {
		JRadioButtonMenuItem rotationItem = new JRadioButtonMenuItem(text);
		rotationItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.setRotation(n);
				frame.pack();
			}
		});
		rotationGroup.add(rotationItem);
		rotationMenu.add(rotationItem);
		return rotationItem;
	}

	/**
	 * u\TCYύXṽTuj[ڂ쐬CO[vɒǉB
	 * @param n ݒ肷ZTCY
	 * @param text j[\
	 * @return 쐬j[
	 */
	protected JRadioButtonMenuItem makeDisplaySizeItem(final int n, String text) {
		JRadioButtonMenuItem displaySizeItem = new JRadioButtonMenuItem(text);
		displaySizeItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.setDisplaySize(n);
				frame.pack();
			}
		});
		displaySizeGroup.add(displaySizeItem);
		displaySizeMenu.add(displaySizeItem);
		return displaySizeItem;
	}

	/**
	 * urX^CIṽTuj[쐬CO[vɒǉB
	 * @param n X^Cԍ
	 * @param text j[\
	 * @return 쐬j[
	 */
	protected JRadioButtonMenuItem makeDisplayStyleItem(final int n, String text) {
		JRadioButtonMenuItem gridStyleItem = new JRadioButtonMenuItem(text);
		gridStyleItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.setDisplayStyle(n);
				panel.repaint();
			}
		});
		gridStyleGroup.add(gridStyleItem);
		gridStyleMenu.add(gridStyleItem);
		return gridStyleItem;
	}

	/**
	 * FIj[쐬p⏕\bh
	 * j[ڂ쐬āC[F̑I]j[ɒǉB
	 * @param text j[\
	 * @return 쐬FIpj[
	 */
	protected JMenuItem addColorMenuItem(final String text) {
		JMenuItem item = new JMenuItem(text);
		item.addActionListener(changeColorAction);
		colorMenu.add(item);
		return item;
	}

	/**
	 * FݒR}hB 
	 */
	private ActionListener changeColorAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			// ǂ̃j[ڂIꂽɂāCǂ̐FύX邩̏Ō肷B
			Color color = JColorChooser.showDialog(panel, e.getActionCommand(),
					getColor((JMenuItem) e.getSource()));
			if (color != null)
				setColor((JMenuItem) e.getSource(), color);
			panel.repaint();
		}
	};

	/**
	 * j[ڂɑΉF擾 g͊eTuNXƂɎB
	 * @param name Iꂽj[
	 * @return 擾F
	 */
	public Color getColor(JMenuItem name) {
		return null;
	}

	/**
	 * j[ڂɑΉF擾 g͊eTuNXƂɎB
	 * @param name Iꂽj[
	 * @param color ݒ肷F
	 */
	public void setColor(JMenuItem name, Color color) {
	}

	/**
	 * j[sR}hB 
	 */
	private ActionListener commandAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			executeCommand((JMenuItem) e.getSource());
		}
	};

	/**
	 * ǂ̃j[IꂽׂāCΉR}hNB
	 * sCPanelĕ`悷B
	 * @param target Iꂽj[
	 */
	public void executeCommand(JMenuItem target) {
		if (target == newBoardItem)
			command.newBoard();
		else if (target == openItem)
			command.open();
		else if (target == coloseAndOpenItem)
			command.closeAndOpen();
		else if (target == saveItem)
			command.save();
		else if (target == saveImageItem)
			command.saveImage();
		else if (target == copyImageItem)
			command.copyImage();
		else if (target == printItem)
			command.print();
		else if (target == propertyItem)
			command.property();
		else if (target == closeItem)
			command.close();
		else if (target == quiteItem)
			command.quit();
		else if (target == aboutItem)
			command.about();
		else if (target == clearItem)
			command.clear();
		else if (target == undoItem)
			command.undo();
		else if (target == redoItem)
			command.redo();
		else if (target == undoAllItem)
			command.undoAll();
		else if (target == redoAllItem)
			command.redoAll();
		else if (target == palybackItem)
			command.playback();
		else if (target == checkAnswerItem)
			command.checkAnswer();
		else if (target == renewColorItem)
			command.renewColor();
		else if (target == cursorItem)
			command.setCursorOn(target.isSelected());
		else if (target == answerModeItem)
			command.setProblemEditMode(false);
		else if (target == problemEditModeItem)
			command.setProblemEditMode(true);
		else
			executeCommand2(target);
		panel.repaint();
	}
	/**
	 * ǂ̃j[IꂽׂāCΉR}hNB
	 * eTuNXŃI[o[ChB
	 * @param target Iꂽj[
	 */
	public void executeCommand2(JMenuItem target) {
	}

	/**
	 * CommandActionj[ڂ쐬
	 * @param title j[ڕ\eLXg
	 * @param mnumonic V[gJbg
	 * @return 쐬j[
	 */
	protected JMenuItem makeCommandMenuItem(String title, char mnumonic) {
		JMenuItem item = makeJMenuItem(title, mnumonic);
		item.addActionListener(commandAction);
		return item;
	}

	/**
	 * CommandActionWI{^j[ڂ쐬
	 * @param title j[ڕ\eLXg
	 * @param mnumonic V[gJbg
	 * @return 쐬j[
	 */
	protected JMenuItem makeCommandRadioButtonMenuItem(String title,
			char mnumonic) {
		JMenuItem item = makeJRadioButtonMenuItem(title, mnumonic);
		item.addActionListener(commandAction);
		return item;
	}

	/**
	 * CommandAction`FbN{bNXj[ڂ쐬
	 * @param title j[ڕ\eLXg
	 * @param mnumonic V[gJbg
	 * @param initial I
	 * @return 쐬j[
	 */
	protected JCheckBoxMenuItem makeCheckBoxCommandMenuItem(String title,
			char mnumonic, boolean initial) {
		JCheckBoxMenuItem item = makeJCheckBoxMenuItem(title, mnumonic, initial);
		item.addActionListener(commandAction);
		return item;
	}

	/*
	 * ȉCj[쐬p⏕\bh
	 */
	/**
	 * JMenu 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic
	 * @return 쐬JMenuItem
	 */
	public JMenu makeJMenu(String text, char mnemonic) {
		JMenu menu = new JMenu(text);
		menu.setMnemonic(mnemonic);
		return menu;
	}

	/**
	 * JMenuItem 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic
	 * @return 쐬JMenuItem
	 */
	public JMenuItem makeJMenuItem(String text, char mnemonic) {
		return new JMenuItem(text, mnemonic);
	}

	/**
	 * JRadioButtonMenuItem 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic
	 * @return 쐬j[
	 */
	public JMenuItem makeJRadioButtonMenuItem(String text, char mnemonic) {
		JMenuItem item = new JRadioButtonMenuItem(text);
		item.setMnemonic(mnemonic);
		return item;
	}

	/**
	 * JCheckBoxMenuItem 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic V[gJbgL[
	 * @param initial l
	 * @return 쐬JMenuItem
	 */
	public JCheckBoxMenuItem makeJCheckBoxMenuItem(String text, char mnemonic,
			boolean initial) {
		JCheckBoxMenuItem item = new JCheckBoxMenuItem(text);
		item.setMnemonic(mnemonic);
		item.setSelected(initial);
		return item;
	}


}
