package pencilbox.common.gui;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.image.BufferedImage;



/**
 * pl̕\e Nbv{[hɃRs[鏈sNX
 */
/*
 * QlFcore JAVA2 Vol.2 7.13 
 */
public class PanelImageTransfer {  

	private BufferedImage image;
	private PanelBase panel;	

	/**
	 * pl̕\e Nbv{[hɃRs[Ȁs
	 * @param panel Nbv{[hɃRs[pl
	 */
	public void run(PanelBase panel) {
		this.panel = panel;
		makePanelImage();
		copy();
	}

	private void makePanelImage() {
		image = new BufferedImage(panel.getWidth(), panel.getHeight(), BufferedImage.TYPE_INT_ARGB);
		Graphics2D g2 = image.createGraphics();
	 	// wi𔒂œhBȂƁCwiȂĂ܂
		g2.setColor(Color.WHITE);
		g2.fillRect(0, 0, panel.getWidth(), panel.getHeight());
		panel.drawPanel(g2);
	}

   /**
	  Copies the current image to the system clipboard.
   */
   private void copy() {  
	  Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
	  ImageSelection selection = new ImageSelection(image);
	  clipboard.setContents(selection, null);
   }

}

/**
   This class is a wrapper for the data transfer of image objects.
*/
class ImageSelection implements Transferable
{  

	private Image theImage;

   /**
	  Constructs the selection.
	  @param image an image
   */
   public ImageSelection(Image image)
   {  
	  theImage = image;
   }

   public DataFlavor[] getTransferDataFlavors()
   {  
	  return new DataFlavor[] { DataFlavor.imageFlavor };
   }

   public boolean isDataFlavorSupported(DataFlavor flavor)
   {  
	  return flavor.equals(DataFlavor.imageFlavor);
   }

   public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException
   {  
	  if(flavor.equals(DataFlavor.imageFlavor))
	  {  
		 return theImage;
	  }
	  else
	  {  
		 throw new UnsupportedFlavorException(flavor);
	  }
   }

}
