/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import java.io.File;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuBase;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.common.io.IOController;

public class PencilFactory {
    private PencilType pencilType;

    public PencilFactory(PencilType pencilType) {
        this.pencilType = pencilType;
    }

    public static PencilFactory getInstance(PencilType pencilType) {
        return new PencilFactory(pencilType);
    }

    public void createNewFrame() throws PencilBoxClassException {
        Size size = this.pencilType.getDefaultSize();
        this.createNewFrame(size);
    }

    public void createNewFrame(Size size) throws PencilBoxClassException {
        BoardBase board = (BoardBase)ClassUtil.createInstance(this.pencilType, "Board");
        board.setSize(size);
        Problem problem = new Problem(board);
        this.createNewFrame(problem);
    }

    public void createNewFrame(File file) throws PencilBoxException {
        Problem problem = IOController.getInstance(this.pencilType).openFile(file);
        this.createNewFrame(problem);
    }

    public void createNewFrame(Problem problem) throws PencilBoxClassException {
        MenuCommand command = new MenuCommand();
        Frame frame = new Frame();
        MenuBase menu = (MenuBase)ClassUtil.createInstance(this.pencilType, "Menu");
        PanelEventHandler panel = (PanelEventHandler)ClassUtil.createInstance(this.pencilType, "Panel");
        frame.setup(panel);
        menu.setup(command, frame, panel);
        command.setup(this.pencilType, frame, panel, problem);
        panel.setup(problem.getBoard());
        frame.resize();
        frame.centering();
        frame.setVisible(true);
    }

    public void createNewBoard(MenuCommand command, File file) throws PencilBoxException {
        Problem problem = IOController.getInstance(this.pencilType).openFile(file);
        this.createNewBoard(command, problem);
    }

    public void createNewBoard(MenuCommand command, Problem problem) throws PencilBoxClassException {
        PanelEventHandler panel = command.getPanelBase();
        Frame frame = command.getFrame();
        command.setup(this.pencilType, problem);
        panel.setup(problem.getBoard());
        frame.resize();
    }
}

