/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import pencilbox.common.core.Address;
import pencilbox.common.gui.PanelEventHandler;

public class CellCursor {
    protected Address pos = new Address();
    protected PanelEventHandler panel;

    public CellCursor(PanelEventHandler panel) {
        this.panel = panel;
    }

    public int r() {
        return this.pos.r;
    }

    public int c() {
        return this.pos.c;
    }

    public Address getPosition() {
        return this.pos;
    }

    public Address getBoardPosition() {
        Address boardPos = new Address(this.pos);
        this.panel.p2b(boardPos);
        return boardPos;
    }

    public void setPosition(int r, int c) {
        if (this.panel.isOn(r, c)) {
            this.pos.set(r, c);
            this.panel.resetPreviousInput();
        }
    }

    public void setPosition(Address address) {
        this.pos.set(address.r, address.c);
    }

    public void moveUp() {
        this.setPosition(this.pos.r - 1, this.pos.c);
    }

    public void moveLt() {
        this.setPosition(this.pos.r, this.pos.c - 1);
    }

    public void moveDn() {
        this.setPosition(this.pos.r + 1, this.pos.c);
    }

    public void moveRt() {
        this.setPosition(this.pos.r, this.pos.c + 1);
    }

    public void moveLU() {
        this.setPosition(this.pos.r - 1, this.pos.c - 1);
    }

    public void moveLD() {
        this.setPosition(this.pos.r + 1, this.pos.c - 1);
    }

    public void moveRU() {
        this.setPosition(this.pos.r - 1, this.pos.c + 1);
    }

    public void moveRD() {
        this.setPosition(this.pos.r + 1, this.pos.c + 1);
    }

    protected int rows() {
        return this.panel.rows();
    }

    protected int cols() {
        return this.panel.cols();
    }

    protected boolean isOn(int r, int c) {
        return this.panel.isOn(r, c);
    }

    protected boolean isOn(int r, int c, int adjustRow, int adjustCol) {
        return this.panel.isOn(r, c, adjustRow, adjustCol);
    }

    public boolean isAt(Address position) {
        return this.getBoardPosition().equals(position);
    }
}

