/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import pencilbox.common.gui.PanelBase;

public class PanelImageWriter {
    private static final String formatName = "png";
    private BufferedImage image;
    private PanelBase panel;

    public void run(PanelBase panel) {
        this.panel = panel;
        this.makePanelImage();
        this.saveFile();
    }

    private void makePanelImage() {
        this.image = new BufferedImage(this.panel.getBoardRegionSize().width, this.panel.getBoardRegionSize().height, 2);
        Graphics2D g2 = this.image.createGraphics();
        this.panel.drawPanel(g2);
    }

    private void saveFile() {
        if (this.image == null) {
            return;
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        ImageWriter writer = iter.next();
        final List<String> writerSuffixes = Arrays.asList(writer.getOriginatingProvider().getFileSuffixes());
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int p = name.lastIndexOf(46);
                if (p == -1) {
                    return false;
                }
                String suffix = name.substring(p + 1).toLowerCase();
                return writerSuffixes.contains(suffix);
            }

            public String getDescription() {
                return "png files";
            }
        });
        int r = chooser.showSaveDialog(null);
        if (r != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        try {
            ImageOutputStream imageOut = ImageIO.createImageOutputStream(f);
            writer.setOutput(imageOut);
            writer.write(new IIOImage(this.image, null, null));
            imageOut.close();
        }
        catch (IOException exception) {
            JOptionPane.showMessageDialog(null, exception);
        }
    }
}

