/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.util.Iterator;
import pencilbox.common.core.Address;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class DigitPatternHint {
    private Board board;
    private int[][] pattern;
    private int maxNumber = 9;

    int getPattern(int r, int c) {
        return this.pattern[r][c];
    }

    void setupHint(Board board) {
        this.board = board;
        this.pattern = new int[board.rows()][board.cols()];
    }

    void initHint() {
        int c;
        int rows = this.board.rows();
        int cols = this.board.cols();
        int r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                Area area = this.board.getArea(r, c);
                this.pattern[r][c] = area != null ? this.getAllDigitPattern(this.board.getArea(r, c).size()) : this.getAllDigitPattern(this.maxNumber);
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                int n = this.board.getNumber(r, c);
                if (n > 0) {
                    this.checkUsedNumber(r, c, n);
                }
                ++c;
            }
            ++r;
        }
    }

    private int getAllDigitPattern(int number) {
        return ~((-1 << number + 1) + 1);
    }

    boolean canPlace(int r, int c, int n) {
        return (this.pattern[r][c] & 1 << n) > 0;
    }

    void checkUsedNumber(int r0, int c0, int n) {
        int pat = ~((1 << n) + 1);
        int c = c0 - n;
        while (c <= c0 + n) {
            if (this.board.isOn(r0, c)) {
                int[] nArray = this.pattern[r0];
                int n2 = c;
                nArray[n2] = nArray[n2] & pat;
            }
            ++c;
        }
        int r = r0 - n;
        while (r <= r0 + n) {
            if (this.board.isOn(r, c0)) {
                int[] nArray = this.pattern[r];
                int n3 = c0;
                nArray[n3] = nArray[n3] & pat;
            }
            ++r;
        }
        Area area = this.board.getArea(r0, c0);
        if (area != null) {
            Iterator itr = this.board.getArea(r0, c0).iterator();
            while (itr.hasNext()) {
                Address pos = (Address)itr.next();
                int[] nArray = this.pattern[pos.r];
                int n4 = pos.c;
                nArray[n4] = nArray[n4] & pat;
            }
        }
    }
}

