/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class Panel
extends PanelEventHandler {
    private Board board;
    private boolean warnWrongNumber = false;
    private boolean showAllowedNumberDot = false;
    private Color inputColor = Color.BLUE;
    private Color wallColor = new Color(192, 192, 192);
    private Color separationColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private Font smallFont = new Font("SansSerif", 0, 13);
    private Address wallPos = new Address();
    private HintDot hintDot = new HintDot();
    private KakuroCursor kcursor;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    protected void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.smallFont = new Font("SansSerif", 0, this.getCellSize() / 2);
        this.hintDot.setDotSize(this.getCellSize());
    }

    public CellCursor createCursor() {
        this.kcursor = new KakuroCursor(this);
        return this.kcursor;
    }

    public void setProblemEditMode(boolean editable) {
        if (editable) {
            this.setMaxInputNumber(45);
        } else {
            this.setMaxInputNumber(9);
        }
        super.setProblemEditMode(editable);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawGrid(g);
        this.drawBoard(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        int c;
        g.setFont(this.smallFont);
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.isWall(r, c)) {
                    this.drawWall(g, r, c, this.board.getSumH(r, c), this.board.getSumV(r, c));
                }
                ++c;
            }
            ++r;
        }
        g.setFont(this.getNumberFont());
        g.setColor(this.inputColor);
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getNumber(r, c);
                if (state > 0) {
                    if (this.warnWrongNumber && this.board.isMultipleNumber(r, c)) {
                        g.setColor(this.errorColor);
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, state);
                } else if (this.showAllowedNumberDot) {
                    this.placeNumberHint(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void drawWall(Graphics g, int r, int c, int a, int b) {
        g.setColor(this.wallColor);
        this.wallPos.set(r, c);
        this.b2p(this.wallPos);
        int statusA = this.board.getWordStatus(r, c, 1);
        int statusB = this.board.getWordStatus(r, c, 0);
        if (this.getRotation() == 4) {
            int t = a;
            a = b;
            b = t;
            t = statusA;
            statusA = statusB;
            statusB = t;
        }
        g.fillRect(this.toX(this.wallPos.c) + 1, this.toY(this.wallPos.r) + 1, this.getCellSize() - 1, this.getCellSize() - 1);
        g.setColor(this.separationColor);
        g.drawLine(this.toX(this.wallPos.c), this.toY(this.wallPos.r), this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r + 1));
        FontMetrics metrics = g.getFontMetrics();
        String numS = Integer.toString(b);
        if (b > 0) {
            if (this.warnWrongNumber && statusB == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.separationColor);
            }
            g.drawString(numS, this.toX(this.wallPos.c) + (this.getHalfCellSize() - metrics.stringWidth(numS)) / 2 + 1, this.toY(this.wallPos.r) + (this.getHalfCellSize() - metrics.getHeight()) / 2 + metrics.getAscent() + this.getHalfCellSize());
        }
        numS = Integer.toString(a);
        if (a > 0) {
            if (this.warnWrongNumber && statusA == -1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.separationColor);
            }
            g.drawString(numS, this.toX(this.wallPos.c) + (this.getHalfCellSize() - metrics.stringWidth(numS)) / 2 + this.getHalfCellSize(), this.toY(this.wallPos.r) + (this.getHalfCellSize() - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        g.setColor(this.separationColor);
        if (this.board.isWall(r, c + 1)) {
            if (this.getRotation() == 0) {
                g.drawLine(this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r), this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r + 1));
            } else if (this.getRotation() == 4) {
                g.drawLine(this.toX(this.wallPos.c), this.toY(this.wallPos.r + 1), this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r + 1));
            }
        }
        if (this.board.isWall(r + 1, c)) {
            if (this.getRotation() == 0) {
                g.drawLine(this.toX(this.wallPos.c), this.toY(this.wallPos.r + 1), this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r + 1));
            } else if (this.getRotation() == 4) {
                g.drawLine(this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r), this.toX(this.wallPos.c + 1), this.toY(this.wallPos.r + 1));
            }
        }
    }

    public void drawCursor(Graphics g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.getCursorColor());
            g.drawRect(this.toX(this.kcursor.c()) + this.kcursor.getStair() * this.getHalfCellSize(), this.toY(this.kcursor.r()) + (this.kcursor.getStair() ^ 1) * this.getHalfCellSize(), this.getHalfCellSize(), this.getHalfCellSize());
        }
        super.drawCursor(g);
    }

    void placeNumberHint(Graphics g, int r, int c) {
        if (this.board.getRemNo(r, c) == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, this.board.getRemPattern(r, c));
        }
    }

    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos.r, pos.c))) {
            this.board.increaseNumber(pos.r, pos.c);
        }
    }

    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos.r, pos.c))) {
            this.board.decreaseNumber(pos.r, pos.c);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (!this.isTransposed()) {
                if (this.kcursor.getStair() == 0) {
                    this.board.setSumV(pos.r, pos.c, num);
                } else if (this.kcursor.getStair() == 1) {
                    this.board.setSumH(pos.r, pos.c, num);
                }
            } else if (this.kcursor.getStair() == 0) {
                this.board.setSumH(pos.r, pos.c, num);
            } else if (this.kcursor.getStair() == 1) {
                this.board.setSumV(pos.r, pos.c, num);
            }
        } else if (!this.board.isWall(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.removeWall(pos.r, pos.c);
        } else if (!this.board.isWall(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            if (!this.isTransposed()) {
                if (this.kcursor.getStair() == 0) {
                    this.board.setSumV(pos.r, pos.c, 0);
                } else if (this.kcursor.getStair() == 1) {
                    this.board.setSumH(pos.r, pos.c, 0);
                }
            } else if (this.kcursor.getStair() == 0) {
                this.board.setSumH(pos.r, pos.c, 0);
            } else if (this.kcursor.getStair() == 1) {
                this.board.setSumV(pos.r, pos.c, 0);
            }
        }
    }
}

