/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.slitherlink.Board;
import pencilbox.slitherlink.SlitherLinkCursor;
import pencilbox.util.Colors;

public class Panel
extends PanelEventHandler {
    private Board board;
    private boolean warnBranchedLink = false;
    private boolean reddenWrongNumber = false;
    private boolean colorForEachLink = false;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color errorColor = Color.RED;
    private Address pos0 = new Address();
    static final int LINE_COLOR = 1;
    static final int CROSS_COLOR = 2;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMaxInputNumber(3);
        this.removeMouseHandlerCursor();
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public CellCursor createCursor() {
        return new SlitherLinkCursor(this);
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null && this.isProblemEditMode()) {
            this.drawCursor(g);
        }
    }

    public void drawGrid(Graphics g) {
        g.setColor(this.getGridColor());
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                g.fillRect(this.toX(c) + this.getHalfCellSize() - 1, this.toY(r) + this.getHalfCellSize() - 1, 3, 3);
                ++c;
            }
            ++r;
        }
    }

    void drawBoard(Graphics g) {
        int number;
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r = 0;
        while (r < this.board.rows() - 1) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                number = this.board.getNumber(r, c);
                if (number >= 0 && number <= 4) {
                    if (this.warnBranchedLink || this.reddenWrongNumber) {
                        int nline = this.board.lineAround(r, c);
                        if (nline > number) {
                            g.setColor(this.errorColor);
                        } else {
                            g.setColor(this.getNumberColor());
                        }
                    }
                    this.placeNumber2(g, r, c, number);
                } else if (number == 5) {
                    this.placeCircle2(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        int d = 0;
        while (d <= 1) {
            int r2 = 0;
            while (r2 < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    number = this.board.getState(d, r2, c);
                    if (number == 1) {
                        g.setColor(this.lineColor);
                        if (this.colorForEachLink) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r2, c).getID()));
                        }
                        if (this.warnBranchedLink && this.board.isBranchedLink(d, r2, c)) {
                            g.setColor(this.errorColor);
                        }
                        this.placeTraversalLine(g, d, r2, c);
                    } else if (number == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r2, c);
                    }
                    ++c;
                }
                ++r2;
            }
            ++d;
        }
    }

    void placeNumber2(Graphics g, int r, int c, int num) {
        this.pos0.set(r, c);
        this.b2p(this.pos0, -1, -1);
        FontMetrics metrics = g.getFontMetrics();
        String numS = Integer.toString(num);
        g.drawString(numS, this.toX(this.pos0.c) + (this.getCellSize() - 1 - metrics.stringWidth(numS)) / 2 + 1 + this.getHalfCellSize(), this.toY(this.pos0.r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1 + this.getHalfCellSize());
    }

    protected void placeCircle2(Graphics g, int r, int c) {
        this.pos0.set(r, c);
        this.b2p(this.pos0, -1, -1);
        int x = this.toX(this.pos0.c) + (this.getCellSize() - this.getCircleSize()) / 2 + this.getHalfCellSize();
        int y = this.toY(this.pos0.r) + (this.getCellSize() - this.getCircleSize()) / 2 + this.getHalfCellSize();
        g.drawOval(x, y, this.getCircleSize(), this.getCircleSize());
        g.drawOval(x + 1, y + 1, this.getCircleSize() - 2, this.getCircleSize() - 2);
    }

    public void drawCursor(Graphics g) {
        g.setColor(this.getCursorColor());
        g.drawRect(this.toX(this.getCellCursor().c()) + this.getHalfCellSize(), this.toY(this.getCellCursor().r()) + this.getHalfCellSize(), this.getCellSize(), this.getCellSize());
        g.drawRect(this.toX(this.getCellCursor().c()) + this.getHalfCellSize() + 1, this.toY(this.getCellCursor().r()) + this.getHalfCellSize() + 1, this.getCellSize() - 2, this.getCellSize() - 2);
    }

    public void setColorI(int target, Color c) {
        switch (target) {
            case 1: {
                this.lineColor = c;
                break;
            }
            case 2: {
                this.crossColor = c;
            }
        }
    }

    public Color getColorI(int target) {
        switch (target) {
            case 1: {
                return this.lineColor;
            }
            case 2: {
                return this.crossColor;
            }
        }
        return null;
    }

    protected void leftClickedEdge(SideAddress pos) {
        this.board.toggleState(pos.d, pos.r, pos.c, 1);
    }

    protected void rightClickedEdge(SideAddress pos) {
        this.board.toggleState(pos.d, pos.r, pos.c, -1);
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r == dragEnd.r || dragStart.c == dragEnd.c) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r == dragEnd.r || dragStart.c == dragEnd.c) {
            this.board.determineInlineState(dragStart, dragEnd, 0);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, -1);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 5);
        }
    }
}

