/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnWrongWall = false;
    private boolean showContinuousRoom = false;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color noRoomColor = new Color(0xC0C0C0);
    private Color roomBorderColor = Color.BLACK;
    private Color continuousRoomColor = new Color(0x800000);
    private Color errorColor = Color.RED;
    private Color showContinuousWhiteColor = Color.RED;
    private Square draggingSquare;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isWarnWrongWall() {
        return this.warnWrongWall;
    }

    public void setWarnWrongWall(boolean warnWrongWall) {
        this.warnWrongWall = warnWrongWall;
    }

    public boolean isShowContinuousRoom() {
        return this.showContinuousRoom;
    }

    public void setShowContinuousRoom(boolean showContinuousRoom) {
        this.showContinuousRoom = showContinuousRoom;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.isProblemEditMode()) {
            this.drawDragging(g);
        }
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        int st;
        int c;
        int r;
        g.setFont(this.getNumberFont());
        if (this.isShowContinuousRoom()) {
            r = 0;
            while (r < this.board.rows()) {
                c = 0;
                while (c < this.board.cols()) {
                    g.setColor(this.continuousRoomColor);
                    if (this.board.contWH[r][c] >= 3) {
                        g.setColor(this.showContinuousWhiteColor);
                    }
                    if (this.board.contH[r][c] >= 3) {
                        this.placeMidline(g, r, c, 1);
                    }
                    g.setColor(this.continuousRoomColor);
                    if (this.board.contWV[r][c] >= 3) {
                        g.setColor(this.showContinuousWhiteColor);
                    }
                    if (this.board.contV[r][c] >= 3) {
                        this.placeMidline(g, r, c, 0);
                    }
                    ++c;
                }
                ++r;
            }
        }
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                st = this.board.getState(r, c);
                if (this.board.getSquare(r, c) == null) {
                    g.setColor(this.noRoomColor);
                    this.paintCell(g, r, c);
                }
                if (st == 1) {
                    g.setColor(this.paintColor);
                    if (this.isWarnWrongWall() && (this.board.isBlock(r, c) || this.board.chain[r][c] == -1)) {
                        g.setColor(this.errorColor);
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                st = this.board.getState(r, c);
                if (st == 2) {
                    g.setColor(this.circleColor);
                    this.placeCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        Iterator itr = this.board.getSquareListIterator();
        while (itr.hasNext()) {
            g.setColor(this.roomBorderColor);
            Square square = (Square)itr.next();
            this.placeSquare(g, square.r0, square.c0, square.r1, square.c1);
            g.setColor(this.getNumberColor());
            if (square.getNumber() < 0) continue;
            if (this.warnWrongWall && square.getNumber() < square.getNBlack()) {
                g.setColor(Color.WHITE);
                this.placeFilledCircle(g, square.r0, square.c0);
                g.setColor(this.errorColor);
            }
            this.placeNumber(g, square.r0, square.c0, square.getNumber());
        }
    }

    void drawDragging(Graphics g) {
        Square square = this.getDraggingSquare();
        if (square == null) {
            return;
        }
        g.setColor(this.roomBorderColor);
        this.placeSquare(g, square.r0, square.c0, square.r1, square.c1);
    }

    void setDraggingSquare(Square draggingSquare) {
        this.draggingSquare = draggingSquare;
    }

    Square getDraggingSquare() {
        return this.draggingSquare;
    }
}

