/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.util;

import java.awt.Color;

class ColorEntry {
    String name;
    int rgb;
    Color color;
    Color revColor;
    boolean use;
    int[] hsb = new int[3];
    float brightness;
    static int LEVEL = 8;
    static int B_LEVEL = 4;
    static ColorEntry[] namedColor;
    static ColorEntry[] rgbColor;
    static int[] reserved;

    static {
        int[] nArray = new int[8];
        nArray[1] = 255;
        nArray[2] = 65280;
        nArray[3] = 65535;
        nArray[4] = 0xFF0000;
        nArray[5] = 0xFF00FF;
        nArray[6] = 0xFFFF00;
        nArray[7] = 0xFFFFFF;
        reserved = nArray;
    }

    ColorEntry(int value, String name, boolean use) {
        this.name = name;
        this.rgb = value;
        this.use = use;
    }

    void complete() {
        this.color = new Color(this.rgb);
        int rev = this.rgb ^ 0xFFFFFF;
        this.revColor = new Color(rev);
        float[] tmp = new float[3];
        Color.RGBtoHSB(this.color.getRed(), this.color.getBlue(), this.color.getGreen(), tmp);
        this.brightness = tmp[2];
        this.hsb[0] = (int)(tmp[0] * (float)LEVEL);
        if (this.hsb[0] == LEVEL) {
            this.hsb[0] = LEVEL - 1;
        }
        this.hsb[1] = (int)(tmp[1] * (float)LEVEL);
        if (this.hsb[1] == LEVEL) {
            this.hsb[1] = LEVEL - 1;
        }
        this.hsb[2] = (int)(tmp[2] * (float)LEVEL);
        if (this.hsb[2] == LEVEL) {
            this.hsb[2] = LEVEL - 1;
        }
    }

    boolean isReserved() {
        int i = 0;
        while (i < reserved.length) {
            if (reserved[i] == this.rgb) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static void complete(ColorEntry[] list) {
        int i = 0;
        while (i < list.length) {
            list[i].complete();
            ++i;
        }
    }

    static ColorEntry[] getUseAndReservedColor(ColorEntry[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (list[i].use || list[i].isReserved()) {
                ++n;
            }
            ++i;
        }
        ColorEntry[] useList = new ColorEntry[n];
        n = 0;
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2].use || list[i2].isReserved()) {
                useList[n++] = list[i2];
            }
            ++i2;
        }
        return useList;
    }

    static ColorEntry[] getUseColor(ColorEntry[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (list[i].use) {
                ++n;
            }
            ++i;
        }
        ColorEntry[] useList = new ColorEntry[n];
        n = 0;
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2].use) {
                useList[n++] = list[i2];
            }
            ++i2;
        }
        return useList;
    }

    static ColorEntry[] getNamedColor() {
        if (namedColor == null) {
            namedColor = new ColorEntry[]{new ColorEntry(0xF0F8FF, "aliceblue", false), new ColorEntry(16444375, "antiquewhite", false), new ColorEntry(8388564, "aquamarine", false), new ColorEntry(0xF0FFFF, "azure", false), new ColorEntry(16119260, "beige", false), new ColorEntry(16770244, "bisque", false), new ColorEntry(0, "black", false), new ColorEntry(16772045, "blanchedalmond", false), new ColorEntry(255, "blue", false), new ColorEntry(9055202, "blueviolet", false), new ColorEntry(0xA52A2A, "brown", true), new ColorEntry(14596231, "burlywood", false), new ColorEntry(6266528, "cadetblue", false), new ColorEntry(0x7FFF00, "chartreuse", false), new ColorEntry(13789470, "chocolate", true), new ColorEntry(16744272, "coral", false), new ColorEntry(6591981, "cornflowerblue", false), new ColorEntry(16775388, "cornsilk", false), new ColorEntry(14423100, "crimson", true), new ColorEntry(65535, "cyan", false), new ColorEntry(139, "darkblue", false), new ColorEntry(35723, "darkcyan", true), new ColorEntry(12092939, "darkgoldenrod", true), new ColorEntry(0xA9A9A9, "darkgray", false), new ColorEntry(25600, "darkgreen", false), new ColorEntry(12433259, "darkkhaki", false), new ColorEntry(0x8B008B, "darkmagenda", false), new ColorEntry(5597999, "darkolivegreen", false), new ColorEntry(16747520, "darkorange", true), new ColorEntry(10040012, "darkorkid", false), new ColorEntry(0x8B0000, "darkred", true), new ColorEntry(15308410, "darksalmon", false), new ColorEntry(9419919, "darkseagreen", true), new ColorEntry(4734347, "darkslateblue", false), new ColorEntry(0x2F4F4F, "darkslategray", false), new ColorEntry(52945, "darktorquoise", false), new ColorEntry(9699539, "darkviolet", true), new ColorEntry(16716947, "deeppink", false), new ColorEntry(49151, "deepskyblue", true), new ColorEntry(0x696969, "dimgray", false), new ColorEntry(2003199, "dodgerblue", false), new ColorEntry(0xB22222, "fireblick", false), new ColorEntry(0xFFFAF0, "floralwhite", false), new ColorEntry(0x228B22, "forestgreen", false), new ColorEntry(0xDCDCDC, "gainsboro", false), new ColorEntry(0xF8F8FF, "ghostwhite", false), new ColorEntry(16766720, "gold", false), new ColorEntry(14329120, "goldenrod", true), new ColorEntry(0xBEBEBE, "gray", false), new ColorEntry(32768, "green", true), new ColorEntry(11403055, "greenyellow", true), new ColorEntry(0xF0FFF0, "heneydew", false), new ColorEntry(16738740, "hotpink", false), new ColorEntry(0xCD5C5C, "indianred", false), new ColorEntry(4915330, "indigo", true), new ColorEntry(0xFFFFF0, "ivory", false), new ColorEntry(15783308, "khaki", true), new ColorEntry(15132410, "lavender", false), new ColorEntry(0xFFF0F5, "lavenderblush", false), new ColorEntry(8190976, "lawngreen", false), new ColorEntry(16775885, "lemonchiffon", false), new ColorEntry(11393254, "lightblue", true), new ColorEntry(0xF08080, "lightcoral", false), new ColorEntry(0xE0FFFF, "lightcyan", false), new ColorEntry(16448210, "lightgoldenyellow", false), new ColorEntry(0x90EE90, "lightgreen", true), new ColorEntry(0xD3D3D3, "lightgray", false), new ColorEntry(16758465, "lightpink", false), new ColorEntry(16752762, "lightsalmon", true), new ColorEntry(2142890, "lightseagreen", false), new ColorEntry(8900346, "lightskyblue", false), new ColorEntry(0x778899, "lightslategray", false), new ColorEntry(11584734, "lightsteelblue", true), new ColorEntry(0xFFFFE0, "lightyellow", false), new ColorEntry(65280, "lime", true), new ColorEntry(3329330, "limegreen", false), new ColorEntry(16445670, "linen", false), new ColorEntry(0xFF00FF, "magenta", true), new ColorEntry(0x800000, "maroon", false), new ColorEntry(6737322, "mediumaquamarine", false), new ColorEntry(205, "mediumblue", false), new ColorEntry(12211667, "mediumorchid", false), new ColorEntry(9662683, "mediumpurple", true), new ColorEntry(3978097, "mediumseagreen", true), new ColorEntry(8087790, "mediumslateblue", false), new ColorEntry(64154, "mediumspringgreen", false), new ColorEntry(4772300, "mediumturquoise", false), new ColorEntry(13047173, "mediumvioletred", true), new ColorEntry(1644912, "midnightblue", false), new ColorEntry(0xF5FFFA, "mintcream", false), new ColorEntry(16770273, "mistryrose", false), new ColorEntry(16770229, "moccasin", false), new ColorEntry(16768685, "navajowhite", false), new ColorEntry(128, "navy", false), new ColorEntry(16643558, "oldlace", false), new ColorEntry(0x808000, "olive", false), new ColorEntry(7048739, "olivedrab", false), new ColorEntry(16753920, "orange", true), new ColorEntry(16729344, "orangered", false), new ColorEntry(14315734, "orchid", false), new ColorEntry(0xEEE8AA, "palegoldenrod", false), new ColorEntry(10025880, "palegreen", false), new ColorEntry(0xAFEEEE, "paleturquoise", false), new ColorEntry(14381203, "palevioletred", false), new ColorEntry(16773077, "papayawhip", false), new ColorEntry(16767673, "peachpuff", false), new ColorEntry(13468991, "peru", true), new ColorEntry(16761035, "pink", true), new ColorEntry(0xDDA0DD, "plumn", false), new ColorEntry(11591910, "powderblue", false), new ColorEntry(0x800080, "purple", true), new ColorEntry(0xFF0000, "red", false), new ColorEntry(12357519, "rosybrown", false), new ColorEntry(4286945, "royalblue", false), new ColorEntry(9127187, "saddlebrown", false), new ColorEntry(16416882, "salmon", true), new ColorEntry(16032864, "sandybrown", false), new ColorEntry(3050327, "seagreen", false), new ColorEntry(0xFFF5EE, "seashell", false), new ColorEntry(10506797, "sienna", false), new ColorEntry(0xC0C0C0, "silver", false), new ColorEntry(8900331, "skyblue", false), new ColorEntry(6970061, "slateblue", false), new ColorEntry(7372944, "slategray", false), new ColorEntry(0xFFFAFA, "snow", false), new ColorEntry(65407, "springgreen", false), new ColorEntry(4620980, "steelblue", true), new ColorEntry(13808780, "tan", true), new ColorEntry(32896, "teal", false), new ColorEntry(14204888, "thistle", false), new ColorEntry(16737095, "tomato", false), new ColorEntry(4251856, "turquoise", false), new ColorEntry(0xEE82EE, "violet", true), new ColorEntry(16113331, "wheat", false), new ColorEntry(0xFFFFFF, "white", false), new ColorEntry(0xF5F5F5, "whitesmoke", false), new ColorEntry(0xFFFF00, "yellow", true), new ColorEntry(10145074, "yellowgreen", false)};
        }
        return namedColor;
    }

    static ColorEntry[] getRgbColor() {
        if (rgbColor == null) {
            rgbColor = new ColorEntry[]{new ColorEntry(0, "black", false), new ColorEntry(51, "001", false), new ColorEntry(102, "002", false), new ColorEntry(153, "003", false), new ColorEntry(204, "004", false), new ColorEntry(255, "blue", false), new ColorEntry(13056, "010", false), new ColorEntry(13107, "011", false), new ColorEntry(13158, "012", false), new ColorEntry(13209, "013", false), new ColorEntry(13260, "014", false), new ColorEntry(13311, "015", false), new ColorEntry(26112, "020", false), new ColorEntry(26163, "021", false), new ColorEntry(26214, "022", false), new ColorEntry(26265, "023", false), new ColorEntry(26316, "024", false), new ColorEntry(26367, "025", false), new ColorEntry(39168, "030", false), new ColorEntry(39219, "031", false), new ColorEntry(39270, "032", false), new ColorEntry(39321, "033", true), new ColorEntry(39372, "034", false), new ColorEntry(39423, "035", false), new ColorEntry(52224, "040", false), new ColorEntry(52275, "041", false), new ColorEntry(52326, "042", false), new ColorEntry(52377, "043", false), new ColorEntry(52428, "044", false), new ColorEntry(52479, "045", false), new ColorEntry(65280, "lime", true), new ColorEntry(65331, "051", false), new ColorEntry(65382, "052", false), new ColorEntry(65433, "053", false), new ColorEntry(65484, "054", false), new ColorEntry(65535, "cyan", false), new ColorEntry(0x330000, "100", false), new ColorEntry(0x330033, "101", false), new ColorEntry(0x330066, "102", false), new ColorEntry(0x330099, "103", true), new ColorEntry(0x3300CC, "104", false), new ColorEntry(0x3300FF, "105", false), new ColorEntry(0x333300, "110", false), new ColorEntry(0x333333, "111", false), new ColorEntry(0x333366, "112", false), new ColorEntry(0x333399, "113", false), new ColorEntry(0x3333CC, "114", false), new ColorEntry(0x3333FF, "115", false), new ColorEntry(0x336600, "120", false), new ColorEntry(0x336633, "121", false), new ColorEntry(0x336666, "122", false), new ColorEntry(0x336699, "123", false), new ColorEntry(0x3366CC, "124", false), new ColorEntry(0x3366FF, "125", false), new ColorEntry(0x339900, "130", false), new ColorEntry(0x339933, "131", false), new ColorEntry(0x339966, "132", false), new ColorEntry(0x339999, "133", false), new ColorEntry(0x3399CC, "134", false), new ColorEntry(0x3399FF, "135", false), new ColorEntry(0x33CC00, "140", false), new ColorEntry(0x33CC33, "141", false), new ColorEntry(0x33CC66, "142", false), new ColorEntry(0x33CC99, "143", false), new ColorEntry(0x33CCCC, "144", false), new ColorEntry(0x33CCFF, "145", false), new ColorEntry(0x33FF00, "150", false), new ColorEntry(0x33FF33, "151", false), new ColorEntry(0x33FF66, "152", false), new ColorEntry(0x33FF99, "153", false), new ColorEntry(0x33FFCC, "154", false), new ColorEntry(0x33FFFF, "155", false), new ColorEntry(0x660000, "200", false), new ColorEntry(0x660033, "201", false), new ColorEntry(0x660066, "202", false), new ColorEntry(0x660099, "203", false), new ColorEntry(0x6600CC, "204", false), new ColorEntry(0x6600FF, "205", false), new ColorEntry(0x663300, "210", false), new ColorEntry(0x663333, "211", false), new ColorEntry(0x663366, "212", false), new ColorEntry(0x663399, "213", false), new ColorEntry(0x6633CC, "214", false), new ColorEntry(0x6633FF, "215", false), new ColorEntry(0x666600, "220", false), new ColorEntry(0x666633, "221", false), new ColorEntry(0x666666, "222", false), new ColorEntry(0x666699, "223", false), new ColorEntry(0x6666CC, "224", false), new ColorEntry(0x6666FF, "225", false), new ColorEntry(0x669900, "230", true), new ColorEntry(0x669933, "231", false), new ColorEntry(0x669966, "232", true), new ColorEntry(0x669999, "233", false), new ColorEntry(0x6699CC, "234", true), new ColorEntry(0x6699FF, "235", true), new ColorEntry(0x66CC00, "240", true), new ColorEntry(0x66CC33, "241", false), new ColorEntry(0x66CC66, "242", false), new ColorEntry(0x66CC99, "243", true), new ColorEntry(0x66CCCC, "244", false), new ColorEntry(0x66CCFF, "245", false), new ColorEntry(0x66FF00, "250", false), new ColorEntry(0x66FF33, "251", false), new ColorEntry(0x66FF66, "252", true), new ColorEntry(0x66FF99, "253", false), new ColorEntry(0x66FFCC, "254", false), new ColorEntry(0x66FFFF, "255", false), new ColorEntry(0x990000, "300", false), new ColorEntry(0x990033, "301", false), new ColorEntry(0x990066, "302", false), new ColorEntry(0x990099, "303", true), new ColorEntry(0x9900CC, "304", false), new ColorEntry(0x9900FF, "305", false), new ColorEntry(0x993300, "310", true), new ColorEntry(0x993333, "311", false), new ColorEntry(0x993366, "312", true), new ColorEntry(0x993399, "313", false), new ColorEntry(0x9933CC, "314", false), new ColorEntry(0x9933FF, "315", false), new ColorEntry(0x996600, "320", false), new ColorEntry(0x996633, "321", true), new ColorEntry(0x996666, "322", false), new ColorEntry(0x996699, "323", false), new ColorEntry(0x9966CC, "324", false), new ColorEntry(0x9966FF, "325", true), new ColorEntry(0x999900, "330", false), new ColorEntry(0x999933, "331", false), new ColorEntry(0x999966, "332", false), new ColorEntry(0x999999, "333", false), new ColorEntry(0x9999CC, "334", false), new ColorEntry(0x9999FF, "335", true), new ColorEntry(0x99CC00, "340", false), new ColorEntry(0x99CC33, "341", false), new ColorEntry(0x99CC66, "342", false), new ColorEntry(0x99CC99, "343", true), new ColorEntry(0x99CCCC, "344", false), new ColorEntry(0x99CCFF, "345", true), new ColorEntry(0x99FF00, "350", false), new ColorEntry(0x99FF33, "351", false), new ColorEntry(0x99FF66, "352", false), new ColorEntry(0x99FF99, "353", true), new ColorEntry(0x99FFCC, "354", false), new ColorEntry(0x99FFFF, "355", false), new ColorEntry(0xCC0000, "400", false), new ColorEntry(0xCC0066, "402", true), new ColorEntry(0xCC0099, "403", false), new ColorEntry(0xCC00CC, "404", false), new ColorEntry(0xCC00FF, "405", true), new ColorEntry(0xCC3300, "410", true), new ColorEntry(0xCC3333, "411", false), new ColorEntry(0xCC3366, "412", false), new ColorEntry(0xCC3399, "413", false), new ColorEntry(0xCC33CC, "414", false), new ColorEntry(0xCC33FF, "415", false), new ColorEntry(0xCC6600, "420", false), new ColorEntry(0xCC6633, "421", false), new ColorEntry(0xCC6666, "422", true), new ColorEntry(0xCC6699, "423", false), new ColorEntry(0xCC66CC, "424", false), new ColorEntry(0xCC66FF, "425", false), new ColorEntry(0xCC9900, "430", true), new ColorEntry(0xCC9933, "431", false), new ColorEntry(0xCC9966, "432", false), new ColorEntry(0xCC9999, "433", true), new ColorEntry(0xCC99CC, "434", false), new ColorEntry(0xCC99FF, "435", false), new ColorEntry(0xCCCC00, "440", true), new ColorEntry(0xCCCC33, "441", false), new ColorEntry(0xCCCC66, "442", true), new ColorEntry(0xCCCC99, "443", false), new ColorEntry(0xCCCCCC, "444", false), new ColorEntry(0xCCCCFF, "445", false), new ColorEntry(0xCCFF00, "450", true), new ColorEntry(0xCCFF33, "451", false), new ColorEntry(0xCCFF66, "452", false), new ColorEntry(0xCCFF99, "453", true), new ColorEntry(0xCCFFCC, "454", false), new ColorEntry(0xCCFFFF, "455", false), new ColorEntry(0xFF0000, "red", false), new ColorEntry(0xFF0033, "501", false), new ColorEntry(0xFF0066, "502", false), new ColorEntry(0xFF0099, "503", false), new ColorEntry(0xFF00CC, "504", false), new ColorEntry(0xFF00FF, "magenda", false), new ColorEntry(0xFF3300, "510", false), new ColorEntry(0xFF3333, "511", false), new ColorEntry(0xFF3366, "512", true), new ColorEntry(0xFF3399, "513", false), new ColorEntry(0xFF33CC, "514", false), new ColorEntry(0xFF33FF, "515", false), new ColorEntry(0xFF6600, "520", false), new ColorEntry(0xFF6633, "521", true), new ColorEntry(0xFF6666, "522", false), new ColorEntry(0xFF6699, "523", false), new ColorEntry(0xFF66CC, "524", false), new ColorEntry(0xFF66FF, "525", false), new ColorEntry(0xFF9900, "530", true), new ColorEntry(0xFF9933, "531", false), new ColorEntry(0xFF9966, "532", true), new ColorEntry(0xFF9999, "533", true), new ColorEntry(0xFF99CC, "534", true), new ColorEntry(0xFF99FF, "535", false), new ColorEntry(0xFFCC00, "540", true), new ColorEntry(0xFFCC33, "541", false), new ColorEntry(0xFFCC66, "542", false), new ColorEntry(0xFFCC99, "543", false), new ColorEntry(0xFFCCCC, "544", true), new ColorEntry(0xFFCCFF, "545", false), new ColorEntry(0xFFFF00, "yellow", true), new ColorEntry(0xFFFF33, "551", false), new ColorEntry(0xFFFF66, "552", false), new ColorEntry(0xFFFF99, "553", false), new ColorEntry(0xFFFFCC, "554", false), new ColorEntry(0xFFFFFF, "white", false)};
        }
        return rgbColor;
    }
}

