/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.kurodoko.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -2);
    }

    protected void rightPressed(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -1);
        int st = this.board.getState(pos.r(), pos.c());
        this.currentState = st > 0 || st == Board.UNDECIDED_NUMBER ? -1 : this.board.getState(pos.r(), pos.c());
    }

    protected void leftDragged(Address pos) {
    }

    protected void rightDragged(Address pos) {
        int st = this.board.getState(pos.r(), pos.c());
        if (st > 0 || st == Board.UNDECIDED_NUMBER) {
            return;
        }
        if (st == this.currentState) {
            return;
        }
        this.board.changeStateA(pos.r(), pos.c(), this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), Board.UNDECIDED_NUMBER);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos.r(), pos.c(), Board.UNDECIDED_NUMBER);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), Board.UNDECIDED_NUMBER);
            }
        }
    }
}

