/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.BoardBase;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    static final int UNDECIDED_NUMBER = -1;
    private int[][] state;
    private int[][] number;
    private int[][] multiH;
    private int[][] multiV;
    private boolean[][] single;
    private int[][] chain;
    private int maxNumber;
    private int maxChain = 1;
    private int[] adjacentChain = new int[4];

    protected void setup() {
        super.setup();
        int rows = this.rows();
        int cols = this.cols();
        this.number = new int[rows][cols];
        this.state = new int[rows][cols];
        this.single = new boolean[rows][cols];
        this.multiH = new int[rows][cols];
        this.multiV = new int[rows][cols];
        this.chain = new int[rows][cols];
        this.maxNumber = rows > cols ? rows : cols;
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt2(this.state, 0);
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -1) {
                    this.setState(r, c, 0);
                }
                ++c;
            }
            ++r;
        }
    }

    public void initBoard() {
        this.initSingle();
        this.initMulti();
        this.initChain();
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public boolean isBlack(int r, int c) {
        return this.state[r][c] == -2;
    }

    public boolean isWhite(int r, int c) {
        return this.state[r][c] == -1;
    }

    public boolean isUnknown(int r, int c) {
        return this.state[r][c] == 0;
    }

    public boolean isMultipleNumber(int r, int c) {
        return this.multiH[r][c] > 1 || this.multiV[r][c] > 1;
    }

    public boolean isSingle(int r, int c) {
        return this.single[r][c];
    }

    int getChain(int r, int c) {
        return this.chain[r][c];
    }

    void setBlack(int r, int c) {
        this.state[r][c] = -2;
        this.decreseMulti(r, c);
        this.connectChain(r, c);
    }

    void setWhite(int r, int c) {
        int before = this.state[r][c];
        this.state[r][c] = -1;
        if (before == -2) {
            this.increaseMulti(r, c);
            this.cutChain(r, c);
        }
    }

    public void erase(int r, int c) {
        int before = this.getState(r, c);
        this.state[r][c] = 0;
        if (before == -2) {
            this.increaseMulti(r, c);
            this.cutChain(r, c);
        }
    }

    public void changeState(int r, int c, int st) {
        if (st == -2) {
            this.setBlack(r, c);
        } else if (st == -1) {
            this.setWhite(r, c);
        } else if (st == 0) {
            this.erase(r, c);
        }
    }

    public void changeStateA(int r, int c, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.state[r][c], st)));
        this.changeState(r, c, st);
    }

    public void toggleState(int r, int c, int st) {
        if (this.state[r][c] == st) {
            this.changeStateA(r, c, 0);
        } else {
            this.changeStateA(r, c, st);
        }
    }

    boolean isBlock(int r, int c) {
        if (this.isBlack(r, c)) {
            if (r > 0 && this.isBlack(r - 1, c)) {
                return true;
            }
            if (r < this.rows() - 1 && this.isBlack(r + 1, c)) {
                return true;
            }
            if (c > 0 && this.isBlack(r, c - 1)) {
                return true;
            }
            if (c < this.cols() - 1 && this.isBlack(r, c + 1)) {
                return true;
            }
        }
        return false;
    }

    void initChain() {
        int c;
        this.maxChain = 1;
        ArrayUtil.initArrayInt2(this.chain, 0);
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isOnPeriphery(r, c) && this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, 1) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
        r = 1;
        while (r < this.rows() - 1) {
            c = 1;
            while (c < this.cols() - 1) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, ++this.maxChain) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
    }

    int initChain1(int r, int c, int uu, int vv, int n) {
        if (n == 1 && uu != 0 && this.isOnPeriphery(r, c)) {
            return -1;
        }
        this.chain[r][c] = n >= 0 && this.isOnPeriphery(r, c) ? 1 : n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if ((u != -uu || v != -vv) && this.isOn(r + u, c + v) && this.isBlack(r + u, c + v)) {
                    if (this.chain[r + u][c + v] == n) {
                        return -1;
                    }
                    if (this.initChain1(r + u, c + v, u, v, n) == -1) {
                        return -1;
                    }
                }
                v += 2;
            }
            u += 2;
        }
        return n;
    }

    void connectChain(int r, int c) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(r, c)) {
            newChain = 1;
        }
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isOn(r + u, c + v) && this.isBlack(r + u, c + v)) {
                    if (this.isOnPeriphery(r, c) && this.chain[r + u][c + v] == 1) {
                        newChain = -1;
                    }
                    adjacent[k] = this.chain[r + u][c + v];
                    int l = 0;
                    while (l < k) {
                        if (adjacent[k] == adjacent[l]) {
                            newChain = -1;
                        }
                        ++l;
                    }
                    ++k;
                    if (this.chain[r + u][c + v] < newChain) {
                        newChain = this.chain[r + u][c + v];
                    }
                }
                v += 2;
            }
            u += 2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.chain[r][c] = ++this.maxChain;
        } else {
            this.setChain(r, c, newChain);
        }
    }

    void cutChain(int r, int c) {
        this.initChain();
    }

    void setChain(int r, int c, int n) {
        this.chain[r][c] = n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isOn(r + u, c + v) && this.isBlack(r + u, c + v) && this.chain[r + u][c + v] != n) {
                    this.setChain(r + u, c + v, n);
                }
                v += 2;
            }
            u += 2;
        }
    }

    boolean checkDivision() {
        boolean ret = true;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols() - 1) {
                if (this.chain[r][c] == -1) {
                    ret = false;
                }
                ++c;
            }
            ++r;
        }
        return ret;
    }

    boolean checkContinuousBlack() {
        boolean ret = true;
        int r = 0;
        while (r < this.rows() - 1) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isBlock(r, c)) {
                    ret = false;
                }
                ++c;
            }
            ++r;
        }
        return ret;
    }

    boolean checkMulti() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isMultipleNumber(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public int checkAnswerCode() {
        int result = 0;
        if (!this.checkContinuousBlack()) {
            result |= 1;
        }
        if (!this.checkDivision()) {
            result |= 2;
        }
        if (!this.checkMulti()) {
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u5b8c\u6210\u3067\u3059";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append("\u9023\u7d9a\u3059\u308b\u9ed2\u30de\u30b9\u304c\u3042\u308b\n");
        }
        if ((result & 2) == 2) {
            message.append("\u9ed2\u30de\u30b9\u306b\u3088\u308a\u76e4\u9762\u304c\u5206\u65ad\u3055\u308c\u3066\u3044\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u3072\u3068\u308a\u3067\u306a\u3044\u6570\u5b57\u304c\u3042\u308b\n");
        }
        return message.toString();
    }

    void initSingle() {
        int i;
        int c;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                this.single[r][c] = true;
                ++c;
            }
            ++r;
        }
        int[] used = new int[this.maxNumber + 1];
        int r2 = 0;
        while (r2 < this.rows()) {
            i = 1;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int c2 = 0;
            while (c2 < this.cols()) {
                int n = this.number[r2][c2];
                used[n] = used[n] + 1;
                ++c2;
            }
            c2 = 0;
            while (c2 < this.cols()) {
                if (used[this.number[r2][c2]] > 1) {
                    this.single[r2][c2] = false;
                }
                ++c2;
            }
            ++r2;
        }
        c = 0;
        while (c < this.cols()) {
            i = 1;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int r3 = 0;
            while (r3 < this.rows()) {
                int n = this.number[r3][c];
                used[n] = used[n] + 1;
                ++r3;
            }
            r3 = 0;
            while (r3 < this.rows()) {
                if (used[this.number[r3][c]] > 1) {
                    this.single[r3][c] = false;
                }
                ++r3;
            }
            ++c;
        }
    }

    void initMulti() {
        int i;
        int[] used = new int[this.maxNumber + 1];
        int r = 0;
        while (r < this.rows()) {
            i = 0;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] != -2 && this.number[r][c] > 0) {
                    int n = this.number[r][c];
                    used[n] = used[n] + 1;
                }
                ++c;
            }
            c = 0;
            while (c < this.cols()) {
                this.multiH[r][c] = used[this.number[r][c]];
                ++c;
            }
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            i = 0;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int r2 = 0;
            while (r2 < this.rows()) {
                if (this.state[r2][c] != -2 && this.number[r2][c] > 0) {
                    int n = this.number[r2][c];
                    used[n] = used[n] + 1;
                }
                ++r2;
            }
            r2 = 0;
            while (r2 < this.rows()) {
                this.multiV[r2][c] = used[this.number[r2][c]];
                ++r2;
            }
            ++c;
        }
    }

    private void decreseMulti(int r0, int c0) {
        int c = 0;
        while (c < this.cols()) {
            if (this.number[r0][c] == this.number[r0][c0]) {
                int[] nArray = this.multiH[r0];
                int n = c;
                nArray[n] = nArray[n] - 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (this.number[r][c0] == this.number[r0][c0]) {
                int[] nArray = this.multiV[r];
                int n = c0;
                nArray[n] = nArray[n] - 1;
            }
            ++r;
        }
    }

    private void increaseMulti(int r0, int c0) {
        int c = 0;
        while (c < this.cols()) {
            if (this.number[r0][c] == this.number[r0][c0]) {
                int[] nArray = this.multiH[r0];
                int n = c;
                nArray[n] = nArray[n] + 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (this.number[r][c0] == this.number[r0][c0]) {
                int[] nArray = this.multiV[r];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++r;
        }
    }

    int getMaxNumber() {
        return this.maxNumber;
    }

    int[][] getChain() {
        return this.chain;
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

