package pencilbox.common.core;

import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;


/**
 * ՖʕNX̐eNX
 */
public class BoardCopierBase {
	
	/**
	 * Ֆʂ𕡐B
	 * @param src ̔Ֆ
	 * @return Ֆ
	 */
	public BoardBase duplicateBoard(BoardBase src) throws PencilBoxClassException {
		return duplicateBoard(src, 0);
	}
	/**
	 * Ֆʂ]ĕB
	 * @param src ̔Ֆ
	 * @return Ֆ
	 */
	public BoardBase duplicateBoard(BoardBase src, int n) throws PencilBoxClassException {
		BoardBase dst = (BoardBase) ClassUtil.createInstance(this.getClass(), ClassUtil.BOARD_CLASS);
		if (Rotator.isTransposed(n)){
			dst.setSize(new Size(src.cols(), src.rows()));
		} else {
			dst.setSize(new Size(src.rows(), src.cols()));
		}
		copyBoardStates(src, dst, n);
		return dst;
	}
	
	/**
	 * ՖʂTCYύXĕB
	 * @param src ̔Ֆ
	 * @param size ύX̃TCY
	 * @return Ֆ
	 * @throws PencilBoxClassException
	 */
	public BoardBase duplicateBoard(BoardBase src, Size size) throws PencilBoxClassException {
		BoardBase dst = (BoardBase) ClassUtil.createInstance(this.getClass(), ClassUtil.BOARD_CLASS);
		dst.setSize(size);
		copyBoardStates(src, dst, 0);
		return dst;
	}
	
	/**
	 * ՖʏԂ]ĕB
	 * ՖʑÖΏۂƂʂsB
	 * ̂悤ɈȂȏꍇiJbNȂǁjɂẮCeTuNXŎB
	 * @param src ̔Ֆ
	 * @param dst ̔Ֆ
	 * @param n ]ԍ
	 */
	public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
		Rotator rotator = new Rotator(src.rows(), src.cols(), n);
		Address from = new Address(0, 0);
		Address to = rotator.rotateAddress(new Address(0, 0));
		Area region = src.getWholeBoardArea();
		copyRegion(src, dst, region, from, to, n);
	}

	/**
	 * ̈B
	 * ̓Iȏ̓TuNXŋLqB
	 * @param board ҏWՖ
	 * @param region ̈
	 */
	public void eraseRegion(BoardBase board, Area region) {
	}

	/**
	 * ̈敡ʁB
	 * ̓Iȏ̓TuNXŋLqB
	 * @param srcBoard ʌՖ
	 * @param board ʐՖ
	 * @param region ʌ̈
	 * @param from ʌ̈挴_
	 * @param to _̕ʐ
	 * @param rotation ]
	 */
	public void copyRegion(BoardBase srcBoard, BoardBase board, Area region, Address from, Address to, int rotation) {
	}

	/**
	 * ̈敡ʁB
	 * ߂ɔՖʑŜ𕡐Ă畡ʏsB
	 * @param board ҏWՖ
	 * @param region ʌ̈
	 * @param from ʌ̈挴_
	 * @param to _̕ʐ
	 * @param rotation ]
	 */
	public void copyRegion(BoardBase board, Area region, Address from, Address to, int rotation) {
		try {
			BoardBase srcBoard = duplicateBoard(board);
			copyRegion(srcBoard, board, region, from, to, rotation);
		} catch (PencilBoxClassException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * ̈ړB
	 * ߂ɔՖʑŜ𕡐Ă畡ʏsCړ̗̈B
	 * @param board ҏWՖ
	 * @param region ړ̈
	 * @param from ړ̈挴_
	 * @param to _̈ړ
	 * @param rotation ]
	 */
	public void moveRegion(BoardBase board, Area region, Address from, Address to, int rotation) {
		try {
			BoardBase srcBoard = duplicateBoard(board);
			eraseRegion(board, region);
			copyRegion(srcBoard, board, region, from, to, rotation);
		} catch (PencilBoxClassException e) {
			e.printStackTrace();
		}
	}

}
