package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

/**
 * F̃ACR
 */
public class ColorIcon implements Icon {
	
	/** ACRƂĕ\F */
	private Color color;
	/** g̐F */
	private Color borderColor;
	/** ACR̕ */
	private int width;
	/** ACR̍ */
	private int height;
	
	
	/**
	 * F̃ACR̃RXgN^
	 * 
	 * @param color ACRƂĕ\F
	 * @param width ACR̕
	 * @param height ACR̍
	 */
	public ColorIcon(Color color, int width, int height) {
		this(color, color, width, height);
	}
	
	/**
	 * F̃ACR̃RXgN^
	 * 
	 * @param color ACRƂĕ\F
	 * @param borderColor g̐F
	 * @param width ACR̕
	 * @param height ACR̍
	 */
	public ColorIcon(Color color, Color borderColor, int width, int height) {
		if (color == null) {
			throw new NullPointerException();
		}
		if (borderColor == null) {
			throw new NullPointerException();
		}
		
		this.color = color;
		this.borderColor = borderColor;
		this.width = width;
		this.height = height;
	}

	/**
	 * @param c R|[lg
	 * @param g OtBbN
	 * @param x ACR`悷xW
	 * @param y ACR`悷yW
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
	 */
	public void paintIcon(Component c, Graphics g, int x, int y) {
		
		g.setColor(color);
		g.fillRect(x, y, width, height);
		if (!color.equals(borderColor)) {
			g.setColor(borderColor);
			g.drawRect(x, y, width - 1, height - 1);
		}
	}

	/**
	 * ACR̕擾
	 * 
	 * @return ACR̕
	 * @see javax.swing.Icon#getIconWidth()
	 */
	public int getIconWidth() {
		return width;
	}

	/**
	 * ACR̍擾
	 * 
	 * @return ACR̍
	 * @see javax.swing.Icon#getIconHeight()
	 */
	public int getIconHeight() {
		return height;
	}
	
	/**
	 * ACRƂĕ\F擾
	 * 
	 * @return ACRƂĕ\F
	 */
	public Color getColor() {
		return color;
	}
}
