package pencilbox.slalom;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;

/**
 * uX[v}EX^L[쏈NX
 */
public class PanelEventHandler extends PanelEventHandlerBase {

	private Board board;

	private int currentState = Board.OUTER; // hbO̕ӂ̏Ԃ\
	private int currentGate = Board.GATE_HORIZ;

	/**
	 * 
	 */
	public PanelEventHandler() {
		setMaxInputNumber(99);
	}

	protected void setBoard(BoardBase aBoard) {
		board = (Board) aBoard; 
	}

	/*
	 * uX[v}EX
	 */
	protected void leftPressedEdge(SideAddress side) {
//		toggleState(side, Board.LINE);
	}

	protected void rightPressedEdge(SideAddress side) {
		toggleState(side, Board.NOLINE);
	}

	protected void leftDragged(Address dragStart, Address dragEnd) {
		changeLineState(dragStart, dragEnd, Board.LINE);
	}

	protected void leftReleased(Address pos) {
		currentState = Board.OUTER;
	}

	/**
	 * ӂ̏Ԃ st Ő؂ւ
	 * @param pos ӍW
	 * @param st ؂ւ
	 */
	private void toggleState(SideAddress pos, int st) {
		if (st == board.getState(pos)) {
			st = Board.UNKNOWN;
		}
		if (!board.hasWall(pos) || st == Board.UNKNOWN) {
			board.changeStateA(pos, st);
		}
	}

	/**
	 * n_}XƏI_}X񂾐̏Ԃw̏ԂɕύX
	 * n_̕ӂ݂̌̏Ԃw̏Ԃł΁CɕύX
	 * @param pos0 n_}X̍W
	 * @param pos1 I_}X̍W
	 * @param st ύX̏
	 */
	private void changeLineState(Address pos0, Address pos1, int st) {
		int direction = pos0.getDirectionTo(pos1);
		if (direction < 0)
			return;
		SideAddress side = SideAddress.get(pos0, direction);
		if (currentState == Board.OUTER) {
			if (board.getState(side) == st) {
				currentState = Board.UNKNOWN;
			} else {
				currentState = st;
			}
		}
		for (Address p = pos0; !p.equals(pos1); p = p.nextCell(direction)) {
			side = SideAddress.get(p, direction);
			if (board.getState(side) != currentState)
				if (!board.hasWall(side) || currentState == Board.UNKNOWN)
					board.changeStateA(side, currentState);
		}
	}

	/*
	 * uX[vL[
	 */
	protected void numberEntered(Address pos, int num) {
		if (isProblemEditMode()) {
			board.setNumber(pos, num);
			if (num >= 0) {
				board.eraseLinesAround(pos);
			}
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (!board.isWall(posS)) {
					board.setNumber(posS, Board.UNDECIDED_NUMBER);
					if (num >= 0) {
						board.eraseLinesAround(pos);
					}
				}
			}
		}
	}

	protected void spaceEntered(Address pos) {
		if (isProblemEditMode()) {
			board.setNumber(pos, Board.BLANK);
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (board.isWall(posS))
					board.setNumber(posS, Board.BLANK);
			}
		}
	}

	protected void minusEntered(Address pos) {
		if (isProblemEditMode()) {
			int number = board.getNumber(pos);
			if (number == Board.GATE_HORIZ) {
				currentGate = Board.GATE_VERT;
			} else if (number == Board.GATE_VERT) {
				currentGate = Board.GATE_HORIZ;
			}
			board.setNumber(pos, currentGate);
		}
	}

	protected void starEntered(Address pos) {
	}

	protected void plusEntered(Address pos) {
		if (isProblemEditMode()) {
			board.setNumber(pos, Board.GOAL);
		}
	}
}
