/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.kurodoko.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.toggleState(pos, -2);
        int st = this.board.getState(pos);
        this.currentState = st > 0 || st == Board.UNDECIDED_NUMBER ? -2 : st;
    }

    protected void rightPressed(Address pos) {
        this.toggleState(pos, -1);
        int st = this.board.getState(pos);
        this.currentState = st > 0 || st == Board.UNDECIDED_NUMBER ? -1 : st;
    }

    protected void leftDragged(Address pos) {
        this.sweepState(pos);
    }

    protected void rightDragged(Address pos) {
        this.sweepState(pos);
    }

    private void toggleState(Address pos, int st) {
        int state = this.board.getState(pos);
        if (state > 0 || state == Board.UNDECIDED_NUMBER) {
            return;
        }
        if (st == state) {
            st = 0;
        }
        this.board.changeStateA(pos, st);
    }

    private void sweepState(Address pos) {
        int st = this.board.getState(pos);
        if (st > 0 || st == Board.UNDECIDED_NUMBER) {
            return;
        }
        if (this.currentState == st) {
            return;
        }
        if (this.currentState == -2 && this.board.isBlock(pos)) {
            return;
        }
        if (this.currentState == -1 && st == -2) {
            return;
        }
        this.board.changeStateA(pos, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.setNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, Board.UNDECIDED_NUMBER);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeState(pos, Board.UNDECIDED_NUMBER);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, Board.UNDECIDED_NUMBER);
            }
        }
    }
}

