/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellNumberEditStep;
import pencilbox.fillomino.Area;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNSTABLE = 0;
    static final int STABLE = 1;
    static final int UNKNOWN = 0;
    private int[][] state;
    private int[][] number;
    private Area[][] area;
    private List<Area> areaList;
    private Area initializingArea;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isStable(r, c)) {
                    this.number[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    public boolean isStable(int r, int c) {
        return this.state[r][c] == 1;
    }

    public boolean isStable(Address pos) {
        return this.isStable(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isUnknown(int r, int c) {
        return this.number[r][c] == 0;
    }

    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        ArrayUtil.initArrayObject2(this.area, null);
        this.areaList.clear();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0 && this.area[r][c] == null) {
                    this.initArea(r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void initArea(int r, int c) {
        this.initializingArea = new Area(this.getNumber(r, c));
        this.initArea1(r, c);
        this.areaList.add(this.initializingArea);
    }

    private void initArea1(int r, int c) {
        if (!this.isOn(r, c)) {
            return;
        }
        if (this.getArea(r, c) == this.initializingArea) {
            return;
        }
        if (this.getNumber(r, c) != this.initializingArea.getNumber()) {
            return;
        }
        this.initializingArea.add(r, c);
        this.setArea(r, c, this.initializingArea);
        this.initArea1(r - 1, c);
        this.initArea1(r, c - 1);
        this.initArea1(r + 1, c);
        this.initArea1(r, c + 1);
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void changeNumber(int r, int c, int n) {
        int prevNum = this.getNumber(r, c);
        this.setNumber(r, c, n);
        if (prevNum > 0) {
            this.splitArea(r, c, prevNum);
        }
        if (n > 0) {
            this.mergeArea(r, c, n);
        }
    }

    public void changeNumber(Address pos, int n) {
        this.changeNumber(pos.r(), pos.c(), n);
    }

    public void enterNumberA(Address pos, int n) {
        if (n < 0) {
            return;
        }
        if (n == this.getNumber(pos)) {
            return;
        }
        this.fireUndoableEditUpdate(new CellNumberEditStep(pos, this.getNumber(pos), n));
        this.changeNumber(pos, n);
    }

    public void undo(AbstractStep step) {
        CellNumberEditStep s = (CellNumberEditStep)step;
        if (this.isStable(s.getPos())) {
            return;
        }
        this.changeNumber(s.getPos(), s.getBefore());
    }

    public void redo(AbstractStep step) {
        CellNumberEditStep s = (CellNumberEditStep)step;
        if (this.isStable(s.getPos())) {
            return;
        }
        this.changeNumber(s.getPos(), s.getAfter());
    }

    void mergeArea(int r, int c, int number) {
        Area mergedArea = null;
        mergedArea = this.mergeArea1(this.getArea(r - 1, c), mergedArea, number);
        mergedArea = this.mergeArea1(this.getArea(r, c - 1), mergedArea, number);
        mergedArea = this.mergeArea1(this.getArea(r + 1, c), mergedArea, number);
        mergedArea = this.mergeArea1(this.getArea(r, c + 1), mergedArea, number);
        if (mergedArea == null) {
            mergedArea = new Area(number);
            this.areaList.add(mergedArea);
        }
        mergedArea.add(r, c);
        this.setArea(r, c, mergedArea);
    }

    private Area mergeArea1(Area area, Area mergedArea, int number) {
        if (area != null && area.getNumber() == number) {
            if (mergedArea == null) {
                mergedArea = area;
            } else if (mergedArea != area) {
                mergedArea.addAll(area);
                for (Address pos : area) {
                    this.setArea(pos.r(), pos.c(), mergedArea);
                }
                this.areaList.remove(area);
            }
        }
        return mergedArea;
    }

    void splitArea(int r, int c, int number) {
        this.areaList.remove(this.getArea(r, c));
        for (Address pos : this.getArea(r, c)) {
            this.setArea(pos.r(), pos.c(), null);
        }
        if (this.isOn(r - 1, c) && this.getNumber(r - 1, c) == number && this.getArea(r - 1, c) == null) {
            this.initArea(r - 1, c);
        }
        if (this.isOn(r, c - 1) && this.getNumber(r, c - 1) == number && this.getArea(r, c - 1) == null) {
            this.initArea(r, c - 1);
        }
        if (this.isOn(r + 1, c) && this.getNumber(r + 1, c) == number && this.getArea(r + 1, c) == null) {
            this.initArea(r + 1, c);
        }
        if (this.isOn(r, c + 1) && this.getNumber(r, c + 1) == number && this.getArea(r, c + 1) == null) {
            this.initArea(r, c + 1);
        }
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isUnknown(r, c)) {
                    result |= 1;
                }
                ++c;
            }
            ++r;
        }
        for (Area area : this.areaList) {
            int status = area.getStatus();
            if (status == -1) {
                result |= 2;
                continue;
            }
            if (status != 0) continue;
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("fillomino.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append(Messages.getString("fillomino.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("fillomino.AnswerCheckMessage3"));
        }
        return message.toString();
    }
}

