/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import pencilbox.common.io.PzprWriterBase;
import pencilbox.hitori.Board;

public class PzprWriter
extends PzprWriterBase {
    private Board bd;

    protected String getPzprName() {
        return "hitori";
    }

    protected void pzlexport() {
        this.bd = (Board)this.boardBase;
        this.outSize(this.bd.rows(), this.bd.cols());
        this.encodeHitori();
    }

    private void encodeHitori() {
        int count = 0;
        String cm = "";
        int i = 0;
        while (i < this.bd.rows() * this.bd.cols()) {
            String pstr = "";
            int val = this.QnC(i);
            if (val == -2) {
                pstr = "%";
            } else if (val >= 0 && val < 16) {
                pstr = PzprWriter.toString(val, 36);
            } else if (val >= 16 && val < 256) {
                pstr = "-" + PzprWriter.toString(val, 36);
            } else {
                ++count;
            }
            if (count == 0) {
                cm = String.valueOf(cm) + pstr;
            } else {
                cm = String.valueOf(cm) + ".";
                count = 0;
            }
            ++i;
        }
        if (count > 0) {
            cm = String.valueOf(cm) + ".";
        }
        this.outbstr(cm);
    }

    protected int QnC(int i) {
        int n = this.bd.getNumber(this.i2a(i));
        if (n == 0) {
            return -1;
        }
        if (n == -1) {
            return -2;
        }
        return n;
    }
}

