/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAddress
implements Comparable<MAddress> {
    public static final MAddress NOWHERE = new MAddress(-1, -1);
    private int r;
    private int c;

    public MAddress() {
        this(0, 0);
    }

    public MAddress(MAddress pos) {
        this.r = pos.r;
        this.c = pos.c;
    }

    public MAddress(Address pos) {
        this.r = pos.r();
        this.c = pos.c();
    }

    public MAddress(int r, int c) {
        this.r = r;
        this.c = c;
    }

    public static MAddress address(int r, int c) {
        return new MAddress(r, c);
    }

    public int r() {
        return this.r;
    }

    public int c() {
        return this.c;
    }

    public void set(MAddress pos) {
        this.r = pos.r;
        this.c = pos.c;
    }

    public void set(int r, int c) {
        this.r = r;
        this.c = c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MAddress)) {
            return false;
        }
        MAddress address = (MAddress)o;
        return address.r == this.r && address.c == this.c;
    }

    public boolean equals(int rr, int cc) {
        return rr == this.r && cc == this.c;
    }

    public int hashCode() {
        return this.r * 1000 + this.c;
    }

    public boolean isNextTo(MAddress address) {
        return address.r == this.r && (address.c == this.c - 1 || address.c == this.c + 1) || address.c == this.c && (address.r == this.r - 1 || address.r == this.r + 1);
    }

    public boolean isInLine(MAddress address) {
        return address.r == this.r || address.c == this.c;
    }

    public boolean isNowhere() {
        return this.r == -1 && this.c == -1;
    }

    public void setNowhere() {
        this.r = -1;
        this.c = -1;
    }

    public void move(int direction) {
        switch (direction) {
            case 0: {
                --this.r;
                break;
            }
            case 1: {
                --this.c;
                break;
            }
            case 2: {
                ++this.r;
                break;
            }
            case 3: {
                ++this.c;
                break;
            }
        }
    }

    @Override
    public int compareTo(MAddress o) {
        if (this.r < o.r) {
            return -1;
        }
        if (this.r > o.r) {
            return 1;
        }
        if (this.c < o.c) {
            return -1;
        }
        if (this.c > o.c) {
            return 1;
        }
        return 0;
    }

    public static int getDirectionTo(MAddress pos0, MAddress pos1) {
        int r0 = pos0.r();
        int r1 = pos1.r();
        int c0 = pos0.c();
        int c1 = pos1.c();
        int ret = -1;
        if (r0 == r1) {
            if (c0 < c1) {
                ret = 3;
            } else if (c0 > c1) {
                ret = 1;
            }
        } else if (c0 == c1) {
            if (r0 < r1) {
                ret = 2;
            } else if (r0 > r1) {
                ret = 0;
            }
        }
        return ret;
    }

    public int getDirectionTo(MAddress pos) {
        return MAddress.getDirectionTo(this, pos);
    }

    public static MAddress nextCell(MAddress p, int direction) {
        int r = p.r();
        int c = p.c();
        switch (direction) {
            case 0: {
                return new MAddress(r - 1, c);
            }
            case 1: {
                return new MAddress(r, c - 1);
            }
            case 2: {
                return new MAddress(r + 1, c);
            }
            case 3: {
                return new MAddress(r, c + 1);
            }
        }
        return NOWHERE;
    }

    public Address toAddress() {
        return Address.address(this.r(), this.c());
    }

    public String toString() {
        return "[" + this.r + ',' + this.c + ']';
    }
}

