/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;

public class Square {
    private int r0;
    private int c0;
    private int r1;
    private int c1;

    public Square(int ra, int ca, int rb, int cb) {
        this.r0 = ra < rb ? ra : rb;
        this.c0 = ca < cb ? ca : cb;
        this.r1 = ra < rb ? rb : ra;
        this.c1 = ca < cb ? cb : ca;
    }

    public Square(Address posA, Address posB) {
        this(posA.r(), posA.c(), posB.r(), posB.c());
    }

    public Square(Square s) {
        this(s.r0, s.c0, s.r1, s.c1);
    }

    public int r0() {
        return this.r0;
    }

    public int c0() {
        return this.c0;
    }

    public int r1() {
        return this.r1;
    }

    public int c1() {
        return this.c1;
    }

    public void set(int ra, int ca, int rb, int cb) {
        this.r0 = ra < rb ? ra : rb;
        this.c0 = ca < cb ? ca : cb;
        this.r1 = ra < rb ? rb : ra;
        this.c1 = ca < cb ? cb : ca;
    }

    public Address[] getCorners() {
        return new Address[]{Address.address(this.r0, this.c0), Address.address(this.r0, this.c1), Address.address(this.r1, this.c0), Address.address(this.r1, this.c1)};
    }

    public Address p0() {
        return Address.address(this.r0, this.c0);
    }

    public Address p1() {
        return Address.address(this.r1, this.c1);
    }

    public void set(Address p0, Address p1) {
        this.set(p0.r(), p0.c(), p1.r(), p1.c());
    }

    public void changeCorner(int rOld, int cOld, int rNew, int cNew) {
        int ra = this.r0;
        int ca = this.c0;
        int rb = this.r1;
        int cb = this.c1;
        if (ra == rOld) {
            ra = rNew;
        } else if (rb == rOld) {
            rb = rNew;
        }
        if (ca == cOld) {
            ca = cNew;
        } else if (cb == cOld) {
            cb = cNew;
        }
        this.set(ra, ca, rb, cb);
    }

    public int sizeC() {
        return this.c1 - this.c0 + 1;
    }

    public int sizeR() {
        return this.r1 - this.r0 + 1;
    }

    public int getSquareSize() {
        return (this.r1 - this.r0 + 1) * (this.c1 - this.c0 + 1);
    }

    public String toString() {
        return "[" + this.r0 + "," + this.c0 + "," + this.r1 + "," + this.c1 + "]";
    }
}

