/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color color;
    private Color borderColor;
    private int width;
    private int height;

    public ColorIcon(Color color, int width, int height) {
        this(color, color, width, height);
    }

    public ColorIcon(Color color, Color borderColor, int width, int height) {
        if (color == null) {
            throw new NullPointerException();
        }
        if (borderColor == null) {
            throw new NullPointerException();
        }
        this.color = color;
        this.borderColor = borderColor;
        this.width = width;
        this.height = height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.fillRect(x, y, this.width, this.height);
        if (!this.color.equals(this.borderColor)) {
            g.setColor(this.borderColor);
            g.drawRect(x, y, this.width - 1, this.height - 1);
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }
}

