/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.util;

import java.awt.Color;
import java.util.Random;
import pencilbox.util.ColorEntry;

public class Colors {
    private static Color ERROR = Color.RED;
    private static Color WALL = Color.BLUE;
    private static Color SMALL_WALL = Color.CYAN;
    static ColorEntry[] LIST;
    static ColorEntry[] DARK_LIST;
    static ColorEntry[] BRIGHT_LIST;
    private static int SIZE;
    private static int DARK_SIZE;
    private static int BRIGHT_SIZE;
    private static int[] INDEX;
    private static int[] DARK_INDEX;
    private static int[] BRIGHT_INDEX;
    private static int secondIndex;
    private static Random random;

    static {
        random = new Random();
        LIST = ColorEntry.getUseColor(ColorEntry.getNamedColor());
        ColorEntry.complete(LIST);
        SIZE = LIST.length;
        INDEX = Colors.makeIndex(LIST);
        DARK_LIST = Colors.selectDarkColor(LIST, 0.91f, true);
        DARK_INDEX = Colors.makeIndex(DARK_LIST);
        DARK_SIZE = DARK_LIST.length;
        BRIGHT_LIST = Colors.selectDarkColor(LIST, 0.9f, false);
        BRIGHT_INDEX = Colors.makeIndex(BRIGHT_LIST);
        BRIGHT_SIZE = BRIGHT_LIST.length;
    }

    private static ColorEntry[] selectDarkColor(ColorEntry[] list, float brightLevel, boolean darker) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            ColorEntry e = list[i];
            if (darker && e.brightness < brightLevel || !darker && e.brightness > brightLevel) {
                ++n;
            }
            ++i;
        }
        ColorEntry[] selection = new ColorEntry[n];
        n = 0;
        int i2 = 0;
        while (i2 < list.length) {
            ColorEntry e = list[i2];
            if (darker && e.brightness < brightLevel || !darker && e.brightness > brightLevel) {
                selection[n++] = list[i2];
            }
            ++i2;
        }
        return selection;
    }

    private static int[] makeIndex(ColorEntry[] list) {
        int size = list.length;
        int[] index = new int[size];
        int i = 0;
        while (i < size) {
            index[i] = i;
            ++i;
        }
        return index;
    }

    private static int getIndex(int i) {
        int j = i / SIZE * secondIndex + i;
        if (j < 0) {
            j = -j;
        }
        return j % SIZE;
    }

    private static int getIndex(int i, int size) {
        int j = i / size * secondIndex + i;
        if (j < 0) {
            j = -j;
        }
        return j % size;
    }

    public static Color getDarkColor(int i) {
        return Colors.DARK_LIST[Colors.DARK_INDEX[Colors.getIndex((int)i, (int)Colors.DARK_SIZE)]].color;
    }

    public static Color getBrightColor(int i) {
        return Colors.BRIGHT_LIST[Colors.BRIGHT_INDEX[Colors.getIndex((int)i, (int)Colors.BRIGHT_SIZE)]].color;
    }

    public static Color get(int i) {
        if (i == 0) {
            return WALL;
        }
        return Colors.LIST[Colors.INDEX[Colors.getIndex((int)i)]].color;
    }

    public static Color getColor(int i) {
        return Colors.LIST[Colors.INDEX[Colors.getIndex((int)i)]].color;
    }

    public static Color getRevColor(int i) {
        return Colors.LIST[Colors.INDEX[Colors.getIndex((int)i)]].revColor;
    }

    public static Color getError() {
        return ERROR;
    }

    public static Color getSmallWall() {
        return SMALL_WALL;
    }

    public static Color getDefault() {
        return WALL;
    }

    public static void randomize() {
        Colors.randomizeIndex(INDEX);
        Colors.randomizeIndex(DARK_INDEX);
        Colors.randomizeIndex(BRIGHT_INDEX);
    }

    public static void randomizeDarkColor() {
        Colors.randomizeIndex(DARK_INDEX);
    }

    public static void randomizeBrightColor() {
        Colors.randomizeIndex(BRIGHT_INDEX);
    }

    private static void randomizeIndex(int[] index) {
        int size = index.length;
        int i = 0;
        while (i < 1000) {
            int y;
            int x = random.nextInt(size);
            if (x == 0) {
                x = 1;
            }
            if ((y = random.nextInt(size)) == 0) {
                y = 1;
            }
            int t = index[x];
            index[x] = index[y];
            index[y] = t;
            ++i;
        }
        secondIndex = random.nextInt(100000);
    }

    public static int getNewNo() {
        int no = random.nextInt();
        if (no < 0) {
            no = -no;
        }
        return no;
    }
}

