/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.yajilin.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt3(s.getState(), d.getState());
        int r = 0;
        while (r < s.rows()) {
            int c = 0;
            while (c < s.cols()) {
                Address pos0 = Address.address(r, c);
                Address pos = rotator.rotateAddress(pos0);
                if (d.isOn(pos)) {
                    if (s.getNumber(pos0) >= 0) {
                        d.setArrowNumber(pos, s.getArrowNumber(pos0));
                        d.setArrowDirection(pos, rotator.rotateDirection(s.getArrowDirection(pos0)));
                    } else {
                        d.setNumber(pos, s.getNumber(pos0));
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase dstBoardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)dstBoardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (region.contains(s.nextCell(n3))) {
                    int joint = srcBoard.getStateJ(s, n3);
                    int dir = Rotator2.rotateDirection(n3, rotation);
                    if (board.isSideOn(d, dir)) {
                        board.setStateJ(d, dir, joint);
                    }
                }
                ++n2;
            }
            if (!board.isOn(d)) continue;
            int number = srcBoard.getNumber(s);
            if (number >= 0 || number == -2) {
                board.eraseLinesAround(d);
            }
            board.setNumber(d, number);
            if (!board.isNumber(d)) continue;
            board.setArrowDirection(d, Rotator2.rotateDirection(srcBoard.getArrowDirection(s), rotation));
        }
    }

    public void eraseRegion(BoardBase srcBoardBase, Area region) {
        Board board = (Board)srcBoardBase;
        for (Address s : region) {
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (region.contains(Address.nextCell(s, n3))) {
                    board.setStateJ(s, n3, 0);
                }
                ++n2;
            }
            board.setNumber(s, -3);
        }
    }
}

