/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.norinori;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.norinori.Area;
import pencilbox.norinori.Board;
import pencilbox.norinori.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int dragState = 0;
    private int currentState = 0;
    private static final int INIT = 0;
    private static final int PRESS_NEW = 1;
    private static final int PRESS_EXISTING = 2;
    private static final int DRAG_ADD = 3;
    private static final int DRAG_REMOVE = 4;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    @Override
    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area area = this.board.getArea(pos);
            if (area == null) {
                area = new Area();
                this.board.addCellToArea(pos, area);
                this.dragState = 1;
            } else {
                this.dragState = 2;
            }
            this.setDraggingArea(area);
        } else {
            this.toggleState(pos, -2);
            this.currentState = this.board.getState(pos);
        }
    }

    @Override
    protected void leftDragged(Address oldPos, Address pos) {
        if (this.isProblemEditMode()) {
            Area draggingArea = this.getDraggingArea();
            if (draggingArea == null) {
                return;
            }
            Area oldArea = this.board.getArea(pos);
            if (this.dragState == 1 || this.dragState == 2) {
                this.dragState = oldArea == null || oldArea != draggingArea ? 3 : 4;
            }
            if (this.dragState == 3) {
                if (oldArea != null && oldArea != draggingArea) {
                    this.board.removeCellFromArea(pos, oldArea);
                    this.board.addCellToArea(pos, draggingArea);
                } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                    this.board.addCellToArea(pos, draggingArea);
                }
            } else if (this.dragState == 4) {
                if (!this.isOn(oldPos)) {
                    return;
                }
                Area oldoldArea = this.board.getArea(oldPos);
                if (oldoldArea != null) {
                    this.board.removeCellFromArea(oldPos, oldoldArea);
                }
            }
        } else {
            this.sweepState(pos);
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.isProblemEditMode()) {
            if (this.dragState == 2) {
                this.board.removeCellFromArea(pos, this.board.getArea(pos));
            }
            this.setDraggingArea(null);
            this.dragState = 0;
        }
    }

    @Override
    protected void rightPressed(Address pos) {
        if (!this.isProblemEditMode()) {
            this.toggleState(pos, -1);
            this.currentState = this.board.getState(pos);
        }
    }

    @Override
    protected void rightDragged(Address pos) {
        if (!this.isProblemEditMode()) {
            this.sweepState(pos);
        }
    }

    private void toggleState(Address pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeState(pos, st);
    }

    private void sweepState(Address pos) {
        int st = this.board.getState(pos);
        if (st == this.currentState) {
            return;
        }
        this.board.changeState(pos, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        this.isProblemEditMode();
    }

    @Override
    protected void spaceEntered(Address pos) {
        this.isProblemEditMode();
    }

    @Override
    protected void minusEntered(Address pos) {
        this.isProblemEditMode();
    }
}

