/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.event.MouseEvent;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Panel;
import pencilbox.shikaku.Square;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int pivotR = -1;
    private int pivotC = -1;
    private int dragState = 0;
    private int currentState = -1;
    private Address pos3 = Address.NOWHERE;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    protected void leftPressed(Address pos) {
        Square draggingSquare;
        Square sq = this.board.getSquare(pos);
        if (sq == null) {
            draggingSquare = new Square(pos, pos);
        } else {
            draggingSquare = new Square(sq);
            this.dragState = 1;
        }
        this.fixPivot(draggingSquare, pos);
        this.setDraggingSquare(draggingSquare);
    }

    @Override
    protected void leftDragged(Address pos) {
        Square draggingSquare = this.getDraggingSquare();
        if (draggingSquare == null) {
            return;
        }
        if (this.pivotR >= 0 && this.pivotC >= 0) {
            draggingSquare.set(this.pivotR, this.pivotC, pos.r(), pos.c());
        } else if (this.pivotR >= 0 && this.pivotC == -1) {
            draggingSquare.set(this.pivotR, draggingSquare.c0(), pos.r(), draggingSquare.c1());
        } else if (this.pivotR == -1 && this.pivotC >= 0) {
            draggingSquare.set(draggingSquare.r0(), this.pivotC, draggingSquare.r1(), pos.c());
        } else if (this.pivotR == -1) {
            // empty if block
        }
        this.dragState = 2;
        this.fixPivot(draggingSquare, pos);
    }

    private void fixPivot(Square s, Address p) {
        if (this.pivotR == -1) {
            if (p.r() == s.r0()) {
                this.pivotR = s.r1();
            } else if (p.r() == s.r1()) {
                this.pivotR = s.r0();
            }
        }
        if (this.pivotC == -1) {
            if (p.c() == s.c0()) {
                this.pivotC = s.c1();
            } else if (p.c() == s.c1()) {
                this.pivotC = s.c0();
            }
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        int cp;
        Square draggingSquare = this.getDraggingSquare();
        if (draggingSquare == null) {
            return;
        }
        int rp = this.pivotR >= 0 ? this.pivotR : draggingSquare.r0();
        Square sq = this.board.getSquare(rp, cp = this.pivotC >= 0 ? this.pivotC : draggingSquare.c0());
        if (sq == null) {
            this.board.removeOverlappedSquares(draggingSquare, null);
            this.board.addSquare(new Square(draggingSquare));
        } else if (this.dragState == 1 && this.isOn(pos)) {
            this.board.removeSquare(sq);
        } else if (!sq.equals(draggingSquare)) {
            this.board.removeOverlappedSquares(draggingSquare, sq);
            this.board.changeSquare(sq, draggingSquare.p0(), draggingSquare.p1());
        }
        this.setDraggingSquare(null);
        this.resetPivot();
        this.dragState = 0;
    }

    private void resetPivot() {
        this.pivotR = -1;
        this.pivotC = -1;
    }

    @Override
    protected void rightPressed3(MouseEvent e) {
        Address sa;
        this.pos3 = sa = this.pointToSuperAddress(e, 0.5);
    }

    @Override
    protected void rightDragged3(MouseEvent e) {
        Address sa = this.pointToSuperAddress(e, 0.5);
        if (this.pos3.equals(sa)) {
            return;
        }
        if (this.pos3.r() != sa.r() && this.pos3.c() != sa.c()) {
            return;
        }
        int dir = this.pos3.getDirectionTo(sa);
        Address sb = Address.nextCell(this.pos3, dir);
        SideAddress b = this.superAddress2SideAddress(sb);
        if (!this.isSideOn(b)) {
            return;
        }
        this.sweepEdgeState(b, 1);
        this.pos3 = sa;
    }

    @Override
    protected void rightReleased(Address pos) {
        this.currentState = -1;
    }

    private void sweepEdgeState(SideAddress side, int st) {
        if (this.currentState == -1) {
            this.currentState = this.board.getEdge(side) == 1 ? 0 : 1;
        }
        this.board.changeEdge(side, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.changeNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, -1);
            }
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, 0);
            }
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, -1);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.changeNumber(posS, -1);
            }
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        ((Panel)this.getPanel()).setDraggingSquare(draggingSquare);
    }

    Square getDraggingSquare() {
        return ((Panel)this.getPanel()).getDraggingSquare();
    }
}

