/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.io.PrintWriter;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.io.TxtWriterBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;

public class TxtWriter
extends TxtWriterBase {
    @Override
    public void writeProblem(PrintWriter out, BoardBase puzzleBoard, int mode) {
        Board board = (Board)puzzleBoard;
        out.println(board.rows());
        out.println(board.cols());
        int r = 0;
        while (r < board.rows()) {
            int c = 0;
            while (c < board.cols()) {
                int num = board.getNumber(r, c);
                if (num == 0) {
                    out.print('.');
                } else {
                    out.print(num);
                }
                out.print(' ');
                ++c;
            }
            out.println();
            ++r;
        }
        if (mode == QUESTION_ONLY) {
            return;
        }
        out.println(board.getSquareList().size());
        for (Square sq : board.getSquareList()) {
            out.print(sq.r0());
            out.print(' ');
            out.print(sq.c0());
            out.print(' ');
            out.print(sq.r1());
            out.print(' ');
            out.print(sq.c1());
            out.println();
        }
        boolean useEdgeData = false;
        SideAddress[] sideAddressArray = board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress pp = sideAddressArray[n2];
            if (board.getEdge(pp) == 1) {
                useEdgeData = true;
                break;
            }
            ++n2;
        }
        if (useEdgeData) {
            sideAddressArray = board.borderAddrs();
            n = sideAddressArray.length;
            n2 = 0;
            while (n2 < n) {
                SideAddress p = sideAddressArray[n2];
                out.print(board.getEdge(p));
                out.print(' ');
                ++n2;
            }
            out.println();
        }
    }
}

