/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.hashi.Board;
import pencilbox.hashi.Pier;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Address pos;
        int c;
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        int r = 0;
        while (r < s.rows()) {
            c = 0;
            while (c < s.cols()) {
                pos = Address.address(r, c);
                if (d.isOn(pos = rotator.rotateAddress(pos))) {
                    d.setNumber(pos.r(), pos.c(), s.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < s.rows()) {
            c = 0;
            while (c < s.cols()) {
                pos = Address.address(r, c);
                if (d.isOn(pos = rotator.rotateAddress(pos))) {
                    int st = s.getState(r, c);
                    if (rotator.isTransposed()) {
                        d.setState(pos.r(), pos.c(), (st & 3) << 2 | (st & 0xC) >> 2);
                    } else {
                        d.setState(pos.r(), pos.c(), st);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Address d;
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.changeNumber(d, srcBoard.getNumber(s));
        }
        for (Address s : region) {
            d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d) || !srcBoard.isPier(s)) continue;
            Pier pi = srcBoard.getPier(s);
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int dir = nArray[n2];
                Pier pi2 = pi.getNextPier(dir);
                if (pi2 != null) {
                    int n3 = pi.getLine(dir);
                    Address s2 = pi.getNextPier(dir).getPos();
                    if (region.contains(s2)) {
                        Address d2 = this.translateAndRotateAddress(s2, from, to, rotation);
                        int ddir = Rotator2.rotateDirection(dir, rotation);
                        if (board.isOn(d2) && board.getPier(d).getNextPier(ddir).getPos().equals(d2)) {
                            board.changeLine(d, ddir, n3);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, AreaBase region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.changeNumber(s, 0);
        }
    }
}

