/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.event.MouseEvent;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;
import pencilbox.tentaisho.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int dragState = 0;
    private int currentState = -1;
    private Address pos3 = Address.NOWHERE;
    private static final int INIT = 0;
    private static final int PRESS_NEW = 1;
    private static final int PRESS_EXISTING = 2;
    private static final int DRAG_ADD = 3;
    private static final int DRAG_REMOVE = 4;

    public PanelEventHandler() {
        this.setMaxInputNumber(2);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public boolean isCursorOnBoard(Address pos) {
        return this.board.isOnStar(pos);
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    @Override
    protected void leftPressed(Address pos) {
        Area area = this.board.getArea(pos);
        if (area == null) {
            area = new Area();
            this.board.addCellToArea(pos, area);
            this.dragState = 1;
        } else {
            this.dragState = 2;
        }
        this.setDraggingArea(area);
    }

    @Override
    protected void leftDragged(Address oldPos, Address pos) {
        Area draggingArea = this.getDraggingArea();
        if (draggingArea == null) {
            return;
        }
        Area oldArea = this.board.getArea(pos);
        if (this.dragState == 1 || this.dragState == 2) {
            this.dragState = oldArea == null || oldArea != draggingArea ? 3 : 4;
        }
        if (this.dragState == 3) {
            if (oldArea != null && oldArea != draggingArea) {
                this.board.removeCellFromArea(pos, oldArea);
                this.board.addCellToArea(pos, draggingArea);
            } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                this.board.addCellToArea(pos, draggingArea);
            }
        } else if (this.dragState == 4) {
            if (!this.isOn(oldPos)) {
                return;
            }
            Area oldoldArea = this.board.getArea(oldPos);
            if (oldoldArea != null) {
                this.board.removeCellFromArea(oldPos, oldoldArea);
            }
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.dragState == 2) {
            this.board.removeCellFromArea(pos, this.board.getArea(pos));
        }
        this.setDraggingArea(null);
        this.dragState = 0;
    }

    @Override
    protected void rightPressed3(MouseEvent e) {
        Address sa;
        this.pos3 = sa = this.pointToSuperAddress(e, 0.5);
    }

    @Override
    protected void rightDragged3(MouseEvent e) {
        Address sa = this.pointToSuperAddress(e, 0.5);
        if (this.pos3.equals(sa)) {
            return;
        }
        if (this.pos3.r() != sa.r() && this.pos3.c() != sa.c()) {
            return;
        }
        int dir = this.pos3.getDirectionTo(sa);
        Address sb = Address.nextCell(this.pos3, dir);
        SideAddress b = this.superAddress2SideAddress(sb);
        if (!this.isSideOn(b)) {
            return;
        }
        this.sweepEdgeState(b, 1);
        this.pos3 = sa;
    }

    @Override
    protected void rightReleased(Address pos) {
        this.currentState = -1;
    }

    private void sweepEdgeState(SideAddress side, int st) {
        if (this.currentState == -1) {
            this.currentState = this.board.getEdge(side) == 1 ? 0 : 1;
        }
        this.board.changeEdge(side, this.currentState);
    }

    @Override
    protected void moveCursor(Address pos) {
    }

    @Override
    protected void numberEntered(Address pos, int n) {
        if (this.isProblemEditMode() && (n == 2 || n == 1)) {
            this.board.changeStar(pos, n);
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeStar(pos, 0);
        }
    }
}

