/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.hitori.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Color soleNumberColor = new Color(0xC0C0C0);

    public Panel() {
        this.setMarkStyle(2);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int state = this.board.getState(p);
            this.drawState(g, p, state);
            int number = this.board.getNumber(p);
            if (number > 0) {
                this.drawNumber1(g, p, number);
            } else if (number == -1) {
                this.placeBoldCircle(g, p);
            }
            ++n2;
        }
    }

    private void drawState(Graphics2D g, Address p, int state) {
        if (state == -2) {
            g.setColor(this.getPaintColor());
            if (this.isIndicateErrorMode()) {
                if (this.board.getChain(p) == -1) {
                    g.setColor(this.getErrorColor());
                }
                if (this.board.isBlock(p)) {
                    g.setColor(this.getErrorColor());
                }
            }
            this.paintCell(g, p);
        } else if (state == -1) {
            g.setColor(this.getCircleColor());
            this.placeMark(g, p);
        }
    }

    private void drawNumber1(Graphics2D g, Address p, int number) {
        g.setColor(this.getNumberColor());
        if (this.isHideSoleNumberMode() && this.board.isSingle(p)) {
            g.setColor(this.soleNumberColor);
        }
        if (this.isIndicateErrorMode() && !this.board.isBlack(p) && this.board.isRedundantNumber(p)) {
            g.setColor(this.getErrorColor());
        }
        if (number <= this.letters.length) {
            this.placeLetter(g, p, this.letters[number - 1]);
        } else {
            this.placeNumber(g, p, number);
        }
    }
}

