/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;
import pencilbox.common.core.UndoManager;
import pencilbox.resource.Messages;

public class BoardBase {
    private UndoManager undoManager;
    private Size size;
    private Address[] cellAddrs;
    private SideAddress[] borderAddrs;
    public static final String COMPLETE_MESSAGE = Messages.getString("BoardBase.MessageComplete");

    public void setSize(Size size) {
        Address.createAddressInstances(size);
        SideAddress.createSideAddressInstances(size);
        this.size = size;
        this.prepareAddresse();
        this.setup();
    }

    public void setSize(int r, int c) {
        this.setSize(new Size(r, c));
    }

    protected void setup() {
    }

    protected void prepareAddresse() {
        int p;
        int c;
        this.cellAddrs = new Address[this.rows() * this.cols()];
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                this.cellAddrs[r * this.cols() + c] = Address.address(r, c);
                ++c;
            }
            ++r;
        }
        this.borderAddrs = new SideAddress[this.rows() * (this.cols() - 1) + (this.rows() - 1) * this.cols()];
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols() - 1) {
                p = r * (this.cols() - 1) + c;
                this.borderAddrs[p] = SideAddress.sideAddress(0, r, c);
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows() - 1) {
            c = 0;
            while (c < this.cols()) {
                p = this.rows() * (this.cols() - 1) + r * this.cols() + c;
                this.borderAddrs[p] = SideAddress.sideAddress(1, r, c);
                ++c;
            }
            ++r;
        }
    }

    public void setUndoManager(UndoManager u) {
        this.undoManager = u;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public Size getSize() {
        return this.size;
    }

    public final int rows() {
        return this.size.getRows();
    }

    public boolean isRecordUndo() {
        if (this.getUndoManager() != null) {
            return this.getUndoManager().isRecordUndo();
        }
        return false;
    }

    public void setRecordUndo(boolean b) {
        if (this.getUndoManager() != null) {
            this.getUndoManager().setRecordUndo(b);
        }
    }

    public void startCompoundUndo() {
        this.getUndoManager().startCompoundUndo();
    }

    public void stopCompoundUndo() {
        this.getUndoManager().stopCompoundUndo();
    }

    public final int cols() {
        return this.size.getCols();
    }

    public boolean isOn(int r, int c) {
        return r >= 0 && r < this.rows() && c >= 0 && c < this.cols();
    }

    public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
        return r >= 0 && r < this.rows() + adjustRow && c >= 0 && c < this.cols() + adjustCol;
    }

    public boolean isOn(Address position) {
        return this.isOn(position.r(), position.c());
    }

    public boolean isOnAll(Address ... positions) {
        Address[] addressArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isOn(p)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isSideOn(int d, int r, int c) {
        if (d == 0) {
            return r >= 0 && r < this.rows() && c >= 0 && c < this.cols() - 1;
        }
        if (d == 1) {
            return r >= 0 && r < this.rows() - 1 && c >= 0 && c < this.cols();
        }
        return false;
    }

    public boolean isSideOn(SideAddress position) {
        return this.isSideOn(position.d(), position.r(), position.c());
    }

    public boolean isSideOn(Address pos, int dir) {
        switch (dir) {
            case 0: {
                return this.isSideOn(1, pos.r() - 1, pos.c());
            }
            case 1: {
                return this.isSideOn(0, pos.r(), pos.c() - 1);
            }
            case 2: {
                return this.isSideOn(1, pos.r(), pos.c());
            }
            case 3: {
                return this.isSideOn(0, pos.r(), pos.c());
            }
        }
        return false;
    }

    public boolean isAreaOn(AreaBase area) {
        for (Address pos : area) {
            if (this.isOn(pos)) continue;
            return false;
        }
        return true;
    }

    public AreaBase getWholeBoardArea() {
        AreaBase area = new AreaBase();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                area.add(Address.address(r, c));
                ++c;
            }
            ++r;
        }
        return area;
    }

    public Address[] cellAddrs() {
        return this.cellAddrs;
    }

    public SideAddress[] borderAddrs() {
        return this.borderAddrs;
    }

    public void clearBoard() {
    }

    public void trimAnswer() {
    }

    public void exchangeNumbers(int v0, int v1) {
    }

    public void trimAnswer1() {
        this.startCompoundUndo();
        this.trimAnswer();
        this.stopCompoundUndo();
    }

    public void initBoard() {
    }

    public boolean isOnPeriphery(int r, int c) {
        return r == 0 || r == this.rows() - 1 || c == 0 || c == this.cols() - 1;
    }

    public boolean isOnPeriphery(Address p) {
        return this.isOnPeriphery(p.r(), p.c());
    }

    protected void fireUndoableEditUpdate(AbstractStep e) {
        this.undoManager.addEdit(e);
    }

    public void undo(AbstractStep step) {
    }

    public void redo(AbstractStep step) {
    }

    public String checkAnswerString() {
        return Messages.getString("BoardBase.MessageUnavailable");
    }

    public int checkAnswerCode() {
        return 0;
    }
}

