/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import java.io.File;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.core.UndoManager;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuBase;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PreferencesCopierBase;
import pencilbox.common.io.IOController;

public class PencilFactory {
    private PencilType pencilType;
    private MenuCommand caller;

    public PencilFactory(PencilType pencilType) {
        this.pencilType = pencilType;
    }

    public static PencilFactory getInstance(PencilType pencilType) {
        return new PencilFactory(pencilType);
    }

    public static PencilFactory getInstance(PencilType pencilType, MenuCommand caller) {
        PencilFactory f = new PencilFactory(pencilType);
        f.pencilType = pencilType;
        f.caller = caller;
        return f;
    }

    public void createNewFrame() throws PencilBoxClassException {
        Size size = this.pencilType.getDefaultSize();
        this.createNewFrame(size);
    }

    public void createNewFrame(Size size) throws PencilBoxClassException {
        BoardBase board = (BoardBase)ClassUtil.createInstance(this.pencilType, "Board");
        board.setSize(size);
        Problem problem = new Problem(board);
        this.createNewFrame(problem);
    }

    public void createNewFrame(File file) throws PencilBoxException {
        Problem problem = IOController.getInstance(this.pencilType).openFile(file);
        this.createNewFrame(problem);
    }

    public boolean createNewFrame(String string) throws PencilBoxException {
        Problem problem = IOController.getInstance(this.pencilType).openFile(string);
        if (problem != null) {
            this.createNewFrame(problem);
            return true;
        }
        return false;
    }

    public void createNewFrame(Problem problem) throws PencilBoxClassException {
        MenuCommand command = new MenuCommand();
        Frame frame = new Frame();
        MenuBase menu = (MenuBase)ClassUtil.createInstance(this.pencilType, "Menu");
        PanelBase panel = (PanelBase)ClassUtil.createInstance(this.pencilType, "Panel");
        EventHandlerManager handler = new EventHandlerManager(this.pencilType);
        frame.setup(panel);
        command.setup(this.pencilType, frame, panel, handler, problem);
        panel.setup(problem.getBoard());
        handler.setup(panel, problem.getBoard());
        this.copyPreferences(command);
        menu.setup(command, frame, panel);
        menu.updateCurrentMenuSelection();
        frame.resize();
        if (this.caller == null) {
            frame.locateAtCenter();
        } else {
            frame.locateAtShiftPosition(this.caller.getFrame());
        }
        frame.setVisible(true);
    }

    public void createNewBoard(File file) throws PencilBoxException {
        Problem problem = IOController.getInstance(this.pencilType).openFile(file);
        this.createNewBoard(problem);
    }

    public void createNewBoard(Problem problem) throws PencilBoxClassException {
        PanelBase panel = this.caller.getPanelBase();
        EventHandlerManager handler = this.caller.getEventHandlerManager();
        Frame frame = this.caller.getFrame();
        this.caller.setup(this.pencilType, problem);
        panel.setup(problem.getBoard());
        handler.setup(panel, problem.getBoard());
        frame.resize();
        frame.locateAtSamePosition();
    }

    public void duplicateFrame() throws PencilBoxClassException {
        BoardCopierBase copier = (BoardCopierBase)ClassUtil.createInstance(this.pencilType, "BoardCopier");
        Problem src = this.caller.getProblem();
        Problem problem = new Problem(src, copier.duplicateBoard(src.getBoard()));
        UndoManager um = new UndoManager(problem.getBoard());
        um.copyEdits(src.getBoard().getUndoManager());
        problem.getBoard().setUndoManager(um);
        this.createNewFrame(problem);
    }

    public void rotateBoard(int n) throws PencilBoxClassException {
        BoardCopierBase copier = (BoardCopierBase)ClassUtil.createInstance(this.pencilType, "BoardCopier");
        Problem problem = this.caller.getProblem();
        problem.setBoard(copier.duplicateBoard(problem.getBoard(), n));
        this.createNewBoard(problem);
    }

    public void changeBoardSize(Size size) throws PencilBoxClassException {
        BoardCopierBase copier = (BoardCopierBase)ClassUtil.createInstance(this.pencilType, "BoardCopier");
        Problem problem = this.caller.getProblem();
        problem.setBoard(copier.duplicateBoard(problem.getBoard(), size));
        this.createNewBoard(problem);
    }

    private void copyPreferences(MenuCommand dst) {
        PreferencesCopierBase copier = PreferencesCopierBase.createInstance(this.pencilType);
        if (this.caller == null) {
            File iniFile = new File("pencilbox.ini");
            if (iniFile.canRead()) {
                copier.loadPreferences(dst, iniFile);
            }
        } else {
            copier.copyPreferences(this.caller, dst);
        }
    }
}

