/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pencilbox.common.gui.IndexLetters;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PencilBoxDialog;
import pencilbox.resource.Messages;

public class IndexLettersDialog
extends PencilBoxDialog {
    private static IndexLettersDialog instance = new IndexLettersDialog();
    private JPanel mainPanel;
    private JCheckBox checkBox;
    private JComboBox[] comboBox;
    private PanelBase panel;

    public static IndexLettersDialog getInstance() {
        return instance;
    }

    private IndexLettersDialog() {
    }

    @Override
    protected void makeDialog() {
        this.setDialogType(0);
        super.makeDialog();
        this.makeMainPanel();
    }

    public void setPanel(PanelBase p) {
        this.panel = p;
        this.checkBox.setSelected(p.isIndexMode());
        int i = 0;
        while (i < 2) {
            this.comboBox[i].setSelectedItem(IndexLetters.getIndexLetters(p.getIndexStyle(i)));
            this.comboBox[i].setEnabled(this.checkBox.isSelected());
            ++i;
        }
    }

    private void makeMainPanel() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel labelCols = new JLabel(Messages.getString("IndexLettersDialog.labelCols"));
        JLabel labelRows = new JLabel(Messages.getString("IndexLettersDialog.labelRows"));
        labelCols.setHorizontalAlignment(11);
        labelRows.setHorizontalAlignment(11);
        this.checkBox = new JCheckBox(Messages.getString("IndexLettersDialog.checkBox"));
        this.checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IndexLettersDialog.this.panel.changeIndexMode(IndexLettersDialog.this.checkBox.isSelected());
                IndexLettersDialog.this.panel.repaint();
                int i = 0;
                while (i < 2) {
                    IndexLettersDialog.this.comboBox[i].setEnabled(IndexLettersDialog.this.checkBox.isSelected());
                    ++i;
                }
            }
        });
        this.comboBox = new JComboBox[2];
        int i = 0;
        while (i < 2) {
            this.comboBox[i] = new JComboBox();
            for (IndexLetters letters : IndexLetters.INDEX_LETTERS_LIST) {
                this.comboBox[i].addItem(letters);
            }
            final int ii = i;
            this.comboBox[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexLettersDialog.this.panel.setIndexStyle(ii, ((IndexLetters)IndexLettersDialog.this.comboBox[ii].getSelectedItem()).getStyle());
                    IndexLettersDialog.this.panel.repaint();
                }
            });
            ++i;
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.top = 2;
        constraints.insets.bottom = 2;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        constraints.fill = 1;
        this.addComponent(this.checkBox, constraints, 1, 0, 1, 1);
        this.addComponent(labelCols, constraints, 0, 1, 1, 1);
        this.addComponent(this.comboBox[0], constraints, 1, 1, 1, 1);
        this.addComponent(labelRows, constraints, 0, 2, 1, 1);
        this.addComponent(this.comboBox[1], constraints, 1, 2, 1, 1);
        this.add((Component)this.mainPanel, "Center");
    }

    private void addComponent(Component c, GridBagConstraints constraints, int x, int y, int w, int h) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        this.mainPanel.add(c, constraints);
    }

    @Override
    protected void accept() {
        super.accept();
    }
}

