/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PencilBoxDialog;

public class LinkWidthDialog
extends PencilBoxDialog
implements MouseWheelListener {
    private static LinkWidthDialog instance = new LinkWidthDialog();
    static final int VALUE_MIN = 1;
    static final int VALUE_MAX = 7;
    static final int VALUE_INIT = 3;
    private JSlider slider;
    private JSpinner spinner;
    private PanelBase panel;

    public static LinkWidthDialog getInstance() {
        return instance;
    }

    private LinkWidthDialog() {
    }

    @Override
    protected void makeDialog() {
        this.setDialogType(1);
        super.makeDialog();
        this.makeMainPanel();
    }

    public void setPanel(PanelBase p) {
        this.panel = p;
    }

    private void makeMainPanel() {
        JPanel mainPanel = new JPanel();
        this.makeSlider();
        this.makeSpinner();
        mainPanel.add(this.slider);
        mainPanel.add(this.spinner);
        this.add((Component)mainPanel, "North");
        this.addMouseWheelListener(this);
    }

    private void makeSlider() {
        this.slider = new JSlider(0, 1, 7, 3);
        this.slider.setMajorTickSpacing(12);
        this.slider.setMinorTickSpacing(2);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = LinkWidthDialog.this.slider.getValue();
                LinkWidthDialog.this.spinner.setValue(value);
                LinkWidthDialog.this.panel.setLinkWidth(value);
                LinkWidthDialog.this.panel.repaint();
            }
        });
    }

    private void makeSpinner() {
        SpinnerNumberModel numberModel = new SpinnerNumberModel(3, 1, 7, 1);
        this.spinner = new JSpinner(numberModel);
        this.spinner.setEditor(new JSpinner.NumberEditor(this.spinner, "#"));
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = ((SpinnerNumberModel)LinkWidthDialog.this.spinner.getModel()).getNumber().intValue();
                LinkWidthDialog.this.slider.setValue(value);
            }
        });
    }

    public void init() {
        int m = 7;
        this.slider.setMaximum(m);
        int ts = 1;
        this.slider.setMinorTickSpacing(ts);
        this.slider.setMajorTickSpacing(ts * 2);
        this.slider.setLabelTable(this.slider.createStandardLabels(ts * 2));
        this.slider.setValue(this.panel.getLinkWidth());
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int i) {
        this.slider.setValue(i);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.setValue(this.getValue() - e.getWheelRotation());
    }
}

