/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Panel;
import pencilbox.heyawake.Square;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int pivotR = -1;
    private int pivotC = -1;
    private int dragState = 0;
    private int currentState = 0;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    protected int getMaxInputNumber() {
        Address pos = this.getCellCursor().getPosition();
        Square square = this.board.getSquare(pos);
        if (square != null) {
            return square.mx();
        }
        return 0;
    }

    @Override
    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Square draggingSquare;
            Square sq = this.board.getSquare(pos);
            if (sq == null) {
                draggingSquare = new Square(pos, pos);
            } else {
                draggingSquare = new Square(sq);
                this.dragState = 1;
            }
            this.fixPivot(draggingSquare, pos);
            this.setDraggingSquare(draggingSquare);
        } else {
            this.toggleState(pos, 1);
            this.currentState = this.board.getState(pos);
        }
    }

    @Override
    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Square draggingSquare = this.getDraggingSquare();
            if (draggingSquare == null) {
                return;
            }
            if (this.pivotR >= 0 && this.pivotC >= 0) {
                draggingSquare.set(this.pivotR, this.pivotC, pos.r(), pos.c());
            } else if (this.pivotR >= 0 && this.pivotC == -1) {
                draggingSquare.set(this.pivotR, draggingSquare.c0(), pos.r(), draggingSquare.c1());
            } else if (this.pivotR == -1 && this.pivotC >= 0) {
                draggingSquare.set(draggingSquare.r0(), this.pivotC, draggingSquare.r1(), pos.c());
            } else if (this.pivotR == -1) {
                // empty if block
            }
            this.dragState = 2;
            this.fixPivot(draggingSquare, pos);
        } else {
            this.sweepState(pos);
        }
    }

    private void fixPivot(Square s, Address pos) {
        int r = pos.r();
        int c = pos.c();
        if (this.pivotR == -1) {
            if (r == s.r0()) {
                this.pivotR = s.r1();
            } else if (r == s.r1()) {
                this.pivotR = s.r0();
            }
        }
        if (this.pivotC == -1) {
            if (c == s.c0()) {
                this.pivotC = s.c1();
            } else if (c == s.c1()) {
                this.pivotC = s.c0();
            }
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.isProblemEditMode()) {
            int cp;
            Square draggingSquare = this.getDraggingSquare();
            if (draggingSquare == null) {
                return;
            }
            int rp = this.pivotR >= 0 ? this.pivotR : draggingSquare.r0();
            Square sq = this.board.getSquare(rp, cp = this.pivotC >= 0 ? this.pivotC : draggingSquare.c0());
            if (sq == null) {
                this.board.removeOverlappedSquares(draggingSquare, null);
                this.board.addSquare(new Square(draggingSquare));
            } else if (this.dragState == 1 && this.isOn(pos)) {
                this.board.removeSquare(sq);
            } else if (!sq.equals(draggingSquare)) {
                this.board.removeOverlappedSquares(draggingSquare, sq);
                this.board.changeSquare(sq, draggingSquare.p0(), draggingSquare.p1());
            }
            this.setDraggingSquare(null);
            this.resetPivot();
            this.dragState = 0;
        }
    }

    @Override
    protected void rightPressed(Address pos) {
        if (!this.isProblemEditMode()) {
            this.toggleState(pos, 2);
            this.currentState = this.board.getState(pos);
        }
    }

    @Override
    protected void rightDragged(Address pos) {
        if (!this.isProblemEditMode()) {
            this.sweepState(pos);
        }
    }

    private void resetPivot() {
        this.pivotR = -1;
        this.pivotC = -1;
    }

    private void toggleState(Address pos, int st) {
        if (st == this.board.getState(pos)) {
            st = 0;
        }
        this.board.changeState(pos, st);
    }

    private void sweepState(Address pos) {
        int st = this.board.getState(pos);
        if (this.currentState == st) {
            return;
        }
        if (this.currentState == 1 && this.board.isBlock(pos)) {
            return;
        }
        if (this.currentState == 2 && st == 1) {
            return;
        }
        this.board.changeState(pos, this.currentState);
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos, num);
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos, -1);
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        ((Panel)this.getPanel()).setDraggingSquare(draggingSquare);
    }

    Square getDraggingSquare() {
        return ((Panel)this.getPanel()).getDraggingSquare();
    }
}

