/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int NONUMBER_WALL = 5;
    static final int BULB = -2;
    static final int NOBULB = -3;
    static final int UNKNOWN = -1;
    static final int OUTER = 6;
    private int[][] state;
    private int[][] illuminatedH;
    private int[][] illuminatedV;
    static final String ERR_MULTI_ILLUMINATION = Messages.getString("bijutsukan.AnswerCheckMessage1");
    static final String YET_NOT_ILLUMINATED = Messages.getString("bijutsukan.AnswerCheckMessage2");
    static final String ERR_WRONG_NUMBER = Messages.getString("bijutsukan.AnswerCheckMessage3");

    public static boolean isWall(int st) {
        return st >= 0 && st <= 4 || st == 5;
    }

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.illuminatedV = new int[this.rows()][this.cols()];
        this.illuminatedH = new int[this.rows()][this.cols()];
        ArrayUtil.initArrayInt2(this.state, -1);
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isFloor(p)) {
                this.setState(p, -1);
            }
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -3) {
                this.changeState(p, -1);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initIlluminations();
    }

    void initIlluminations() {
        ArrayUtil.initArrayInt2(this.illuminatedV, 0);
        ArrayUtil.initArrayInt2(this.illuminatedH, 0);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -2) {
                this.illuminate(p, true);
            }
            ++n2;
        }
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        if (this.isOn(r, c)) {
            return this.state[r][c];
        }
        return 6;
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isWall(Address p) {
        int n = this.getState(p);
        return n >= 0 && n <= 4 || n == 5;
    }

    public boolean isNumberedWall(Address p) {
        int n = this.getState(p);
        return n >= 0 && n <= 4;
    }

    public boolean isFloor(Address p) {
        if (this.isOn(p)) {
            int n = this.getState(p);
            return n == -1 || n == -3 || n == -2;
        }
        return false;
    }

    public int getHorizIlluminated(Address p) {
        return this.illuminatedH[p.r()][p.c()];
    }

    public int getVertIlluminated(Address p) {
        return this.illuminatedV[p.r()][p.c()];
    }

    public boolean isMultiIlluminated(Address p) {
        return this.illuminatedV[p.r()][p.c()] > 1 || this.illuminatedH[p.r()][p.c()] > 1;
    }

    public boolean isIlluminated(Address p) {
        return this.illuminatedV[p.r()][p.c()] > 0 || this.illuminatedH[p.r()][p.c()] > 0;
    }

    private void illuminate(Address p0, boolean on) {
        int k = on ? 1 : -1;
        int d = 0;
        while (d < 4) {
            Address p = p0;
            p = p0.nextCell(d);
            while (this.isFloor(p)) {
                this.increaseIlluminated(p, d, k);
                p = p.nextCell(d);
            }
            ++d;
        }
        this.increaseIlluminated(p0, 0, k);
        this.increaseIlluminated(p0, 1, k);
    }

    public void increaseIlluminated(Address p, int d, int k) {
        if ((d & 1) == 0) {
            int[] nArray = this.illuminatedV[p.r()];
            int n = p.c();
            nArray[n] = nArray[n] + k;
        } else if ((d & 1) == 1) {
            int[] nArray = this.illuminatedH[p.r()];
            int n = p.c();
            nArray[n] = nArray[n] + k;
        }
    }

    private void illuminate4(Address p0, boolean on) {
        int d = 0;
        while (d < 4) {
            Address p = p0.nextCell(d);
            while (this.isFloor(p)) {
                if (this.getState(p) == -2) {
                    this.illuminate(p, on);
                }
                p = p.nextCell(d);
            }
            ++d;
        }
    }

    public void changeState(Address p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, st));
        }
        if (Board.isWall(st) || Board.isWall(prev)) {
            this.illuminate4(p, false);
        }
        if (prev == -2 && st != -2) {
            this.illuminate(p, false);
        }
        this.setState(p, st);
        if (st == -2 && prev != -2) {
            this.illuminate(p, true);
        }
        if (Board.isWall(st) || Board.isWall(prev)) {
            this.illuminate4(p, true);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        }
    }

    public int countAdjacentBulbs(Address p0) {
        int count = 0;
        int d = 0;
        while (d < 4) {
            Address p = Address.nextCell(p0, d);
            if (this.getState(p) == -2) {
                ++count;
            }
            ++d;
        }
        return count;
    }

    public int checkAdjacentBulbs(Address p) {
        int number;
        int nBulb = this.countAdjacentBulbs(p);
        if (nBulb > (number = this.getState(p))) {
            return -1;
        }
        if (nBulb == number) {
            return 1;
        }
        if (nBulb < number) {
            return 0;
        }
        return 0;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isWall(p)) {
                if (this.isMultiIlluminated(p)) {
                    result |= 1;
                } else if (!this.isIlluminated(p)) {
                    result |= 2;
                }
            } else if (this.isNumberedWall(p)) {
                if (this.countAdjacentBulbs(p) > this.getState(p)) {
                    result |= 4;
                } else if (this.countAdjacentBulbs(p) < this.getState(p)) {
                    result |= 8;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_MULTI_ILLUMINATION);
        }
        if ((result & 2) == 2) {
            message.append(YET_NOT_ILLUMINATED);
        }
        if ((result & 4) == 4 || (result & 8) == 8) {
            message.append(ERR_WRONG_NUMBER);
        }
        return message.toString();
    }
}

