/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.yajilin.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;
    private static final int NULLSTATE = -9;
    private static final int PRE_BLACK = -19;

    public PanelEventHandler() {
        this.setMaxInputNumber(9);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    protected void leftPressed(Address pos) {
        if (this.board.getNumber(pos) == -2) {
            this.currentState = -19;
        }
    }

    @Override
    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (this.currentState == -19) {
            this.currentState = -2;
        }
        if (this.currentState == -2) {
            this.sweepState(dragEnd);
        } else {
            this.changeLineState(dragStart, dragEnd, 1);
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.isOn(pos)) {
            if (this.currentState == -9) {
                this.toggleState(pos, -2);
            } else if (this.currentState == -19) {
                this.toggleState(pos, -2);
            }
        }
        this.currentState = -9;
    }

    @Override
    protected void rightPressed(Address pos) {
        this.toggleState(pos, -1);
    }

    @Override
    protected void rightDragged(Address pos) {
        this.sweepState(pos);
    }

    @Override
    protected void rightReleased(Address pos) {
        this.currentState = -9;
    }

    private void toggleState(Address pos, int st) {
        if (this.board.isNumber(pos)) {
            return;
        }
        if (st == this.board.getNumber(pos)) {
            st = -3;
        }
        if (st == -2) {
            this.board.eraseLinesAround(pos);
        }
        this.board.changeNumber(pos, st);
        this.currentState = st;
    }

    private void sweepState(Address pos) {
        int st = this.board.getNumber(pos);
        if (st >= 0 || st == -4) {
            return;
        }
        if (st == this.currentState) {
            return;
        }
        if (this.currentState == -2) {
            if (st == -1) {
                return;
            }
            if (this.board.countLine(pos) > 0) {
                return;
            }
            if (this.board.isBlock(pos)) {
                return;
            }
        } else if (this.currentState == -1 && st == -2) {
            return;
        }
        this.board.changeNumber(pos, this.currentState);
    }

    private void changeLineState(Address pos0, Address pos1, int st) {
        int direction = Address.getDirectionTo(pos0, pos1);
        if (direction < 0) {
            this.currentState = st;
            return;
        }
        SideAddress side = SideAddress.get(pos0, direction);
        if (this.currentState == -9) {
            this.currentState = this.board.getState(side) == st ? 0 : st;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            side = SideAddress.get(p, direction);
            if (!(this.board.getState(side) == this.currentState || this.board.hasNumberOrBlack(side) && st != 0)) {
                this.board.changeState(side, this.currentState);
            }
            p = p.nextCell(direction);
        }
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.enterNumber(posS, -4);
            }
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos, -3);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.enterNumber(posS, -3);
            }
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos, -4);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.enterNumber(posS, -4);
            }
        }
    }
}

