package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;
import jp.gr.java_conf.miya.pglauncher.utils.XMLUtils;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;


public class DeleteAction extends AbstractAction {

	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private ConfigDialog dialog_;
	private TreeViewer viewer_;

	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public DeleteAction(ConfigDialog dialog,
						TreeViewer viewer,
						ActionEventProvider provider){
		super("폜(&D)",null,provider);
		dialog_ = dialog;
		viewer_ = viewer;
	}

	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		Element el = TreeUtils.getSelectedElement(viewer_);
		String type = el.getNodeName();
		
		if(type.equals(Const.NODE_ROOT)) return;
		
		NamedNodeMap map = el.getAttributes();
		String name = map.getNamedItem(Const.ATTR_NAME).getNodeValue();
		
		String message = null;
		if(type.equals(Const.NODE_GROUP)) message = name + " O[v폜܂H";
		else message = name + " 폜܂H";
		
		if(MessageDialog.openQuestion(
				viewer_.getControl().getShell(),
				"폜̊mF",
				message)){
			Element parent = (Element)el.getParentNode();
			Document document = (Document)viewer_.getInput();
			XMLUtils.removeNode(document,el);
			viewer_.refresh();
			viewer_.setSelection(new StructuredSelection(parent),true);
			dialog_.modified();
		}
	}
	
	public void doubleClick(Event event){}
	
	public void rightClick(Event event){
		Element el = TreeUtils.getSelectedElement(viewer_);
		String type = el.getNodeName();
		
		if(type.equals(Const.NODE_ROOT)) setEnabled(false);
		else setEnabled(true);
	}
	
	public void keyDown(Event event){
		switch(event.keyCode){
			case SWT.DEL:
				run();
		}
	}
}
