package jp.gr.java_conf.miya.pglauncher.utils;

import java.net.URL;
import java.util.Properties;

import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.Const;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;

public class ImageUtils{
	
	//======================================================================
	// NXϐ
	//======================================================================
	//------------------------------------------------------------ private
	private static ImageRegistry registry_;
	private static Properties imagePaths_;

	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ private
	private ImageUtils(){}
	
	//======================================================================
	// static CjVCU
	//======================================================================
	static{
		registry_ = new ImageRegistry();
		imagePaths_ = new Properties();
		imagePaths_.setProperty(Const.ICON_PGLAUNCHER,	"/icons/pglauncher.gif");
		imagePaths_.setProperty(Const.ICON_GROUP,		"/icons/group.gif");
		imagePaths_.setProperty(Const.ICON_FOLDER,		"/icons/folder.gif");
		imagePaths_.setProperty(Const.ICON_EXE,			"/icons/exe.gif");
		imagePaths_.setProperty(Const.ICON_UNKOWN,		"/icons/unknown.gif");
		imagePaths_.setProperty(Const.ICON_CONFIG,		"/icons/config.gif");
		imagePaths_.setProperty(Const.ICON_ERROR,		"/icons/error.gif");
		imagePaths_.setProperty(Const.ICON_RUN,			"/icons/run.gif");
	}
	
	//======================================================================
	// NX\bh
	//======================================================================
	//------------------------------------------------------------ public
	public static Image getImageFromIcon(String name){
		Image img = registry_.get(name);
		if(img == null){
			_createImageFromIcon(name);
			img = registry_.get(name);
		}
		return img;
	}
	
	public static ImageDescriptor getImageDescriptorFromIcon(String name){
		ImageDescriptor imgDesc = registry_.getDescriptor(name);
		if(imgDesc == null){
			_createImageFromIcon(name);
			imgDesc = registry_.getDescriptor(name);
		}
		return imgDesc;
	}
	
	public static Image getImageFromProgram(String path){
		String extension = path.substring(path.lastIndexOf(".") + 1);
		Image img = null;
		if(extension.equalsIgnoreCase(Const.EXT_EXE)){
			img = registry_.get(path);
		}else{
			img = registry_.get(extension);
		}
		if(img != null) return img;
		_createImageFromProgram(path);
		if(extension.equalsIgnoreCase(Const.EXT_EXE)){
			return registry_.get(path);
		}else{
			return registry_.get(extension);
		}
	}
	
	public static ImageDescriptor getImageDescriptorFromProgram(String path){
		String extension = path.substring(path.lastIndexOf(".") + 1);
		ImageDescriptor imgDesc = null;
		if(extension.equalsIgnoreCase(Const.EXT_EXE)){
			imgDesc = registry_.getDescriptor(path);
		}else{
			imgDesc = registry_.getDescriptor(extension);
		}
		if(imgDesc != null) return imgDesc;
		_createImageFromProgram(path);
		if(extension.equalsIgnoreCase(Const.EXT_EXE)){
			return registry_.getDescriptor(path);
		}else{
			return registry_.getDescriptor(extension);
		}
	}
	
	//------------------------------------------------------------ private
	private static void _createImageFromIcon(String name){
		PGLauncherPlugin plugin = PGLauncherPlugin.getDefault();
		URL url = plugin.getBundle().getEntry(imagePaths_.getProperty(name));
		if(url != null){
			registry_.put(name,ImageDescriptor.createFromURL(url));
		}
	}
	
	private static void _createImageFromProgram(String path){
		String extension = path.substring(path.lastIndexOf(".") + 1);
		if(extension.equalsIgnoreCase(Const.EXT_EXE)){
			TCHAR lpszFile = new TCHAR (0, path, true);
			int [] phiconSmall = new int[1], phiconLarge = null;
			OS.ExtractIconEx (lpszFile, 0, phiconLarge, phiconSmall, 1);
			if (phiconSmall [0] == 0) return;
			Image img = Image.win32_new(null, SWT.ICON, phiconSmall[0]);
			if(img != null){
				ImageData imgData = img.getImageData();
				img.dispose();
				registry_.put(path,new jp.gr.java_conf.miya.pglauncher.common.ImageDescriptor(imgData));
			}
		}else{
			Program prg = Program.findProgram(extension);
			if(prg != null){
				registry_.put(extension,new ExternalProgramImageDescriptor(prg));
			}
		}
	}
}