package jp.gr.java_conf.miya.pglauncher.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.Const;


import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils{
	
	//======================================================================
	// NXϐ
	//======================================================================
	//------------------------------------------------------------ private
	private static XMLUtils instance_;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ private
	private XMLUtils(){}
	
	//======================================================================
	// NX\bh
	//======================================================================
	//------------------------------------------------------------ public
	public static XMLUtils getInstance(){
		if(instance_ == null){
			instance_ = new XMLUtils();
		}
		return instance_;
	}
	
	public static void removeNode(Document document,
									Node node){
		_removeNode(document,node);
	}
	
	//------------------------------------------------------------ private
	private static boolean _removeNode(Node parent,
										Node target){
		NodeList list = parent.getChildNodes();
		for(int i = 0;i < list.getLength();i++){
			Node node = list.item(i);
			if(node.equals(target)){
				parent.removeChild(node);
				return true;
			}else{
				if(node.getChildNodes().getLength() > 0){
					if(_removeNode(node,target)){
						return true;
					}
				}
			}
		}
		return false;
	}
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public Document loadDocument(){
		File file = PGLauncherPlugin.getConfigFile();
		try{
			if(!file.exists()){
				FileWriter writer = new FileWriter(file);
				writer.write(Const.DEFAULT_CONFIGFILE.toString());
				writer.flush();
				writer.close();
			}
			DocumentBuilderFactory factory =
					DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(file);
			return document;
		}catch(Exception e){
			// TODO - G[
			e.printStackTrace();
		}
		return null;
	}
	
	public void saveDocument(Document document){
		File file = PGLauncherPlugin.getConfigFile();
		try{
			DOMSource source = new DOMSource(document);
			FileOutputStream os = new FileOutputStream(file);
			StreamResult result = new StreamResult(os);
			
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT,"yes");
			transformer.setOutputProperty(OutputKeys.METHOD,"xml");
			transformer.transform(source, result);
		}catch(Exception e){
			// TODO - G[
			e.printStackTrace();
		}
	}
}
