<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * It is a tool to test easily according to RDB. 
 * 
 * PHP versions 4 and 5
 * 
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 * 
 * @category    Tools and Utilities
 * @package     PHPUnit_DB
 * @author      uguu <uguu@mail.uguu.mydns.jp>
 * @copyright   Copyright (C) 2005, uguu All rights reserved.
 * @license     http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version     0.1.0
 */

require_once 'PEAR.php';
require_once 'DB.php';
require_once 'PHPUnit.php';

/**
 * PHPUnit_DB_Tool offers the method of the easy examination according to RDB.
 * 
 * @category    Tools and Utilities
 * @package     PHPUnit_DB
 * @author      uguu <uguu@mail.uguu.mydns.jp>
 * @copyright   Copyright (C) 2005, uguu All rights reserved.
 * @license     http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version     0.1.0
 */
class PHPUnit_DB_Tool extends PEAR {
    /**
     * DSN.
     * 
     * @var     string
     * @access  private
     */
    var $dsn;
    /**
     * The PHPUnit_DB_Tool instance accessed RDB by using specified DSN is initialized.
     * 
     * Notes: For PHP4
     * 
     * @param   string  $dsn    DSN.
     * @access  public
     */
    function PHPUnit_DB_Tool($dsn = '')
    {
        PHPUnit_DB_Tool::__construct($dsn);
    }
    /**
     * The PHPUnit_DB_Tool instance accessed RDB by using specified DSN is initialized.
     * 
     * Notes: For PHP5
     * 
     * @param   string  $dsn    DSN.
     * @access  public
     */
    function __construct($dsn = '')
    {
        $this->PEAR('PHPUnit_DB');
        
        $this->dsn = $dsn;
    }
    /**
     * The data stored in the table is returned by the array.
     * The acquired array can be used for the test data by describing it as PHP code by using the var_export() function for instance.
     * 
     * @param   array   $tableNames Array of exporting table name.
     * @return  mixed   Array where data of table is stored.
     *                  DB_Error object when failing in method call.
     * @access  public
     */
    function exportTables($tableNames = array())
    {
        $result = array();
        
        $conn = &$this->_getConnection();
        if (PEAR::isError($conn)) {
            return $conn;
        }
        
        foreach ($tableNames as $tableName) {
            $tableInfo = &$conn->tableInfo($tableName);
            if (PEAR::isError($tableInfo)) {
                $result = &$tableInfo;
                break;
            }
            $primaryKeys = '';
            foreach ($tableInfo as $fieldInfo) {
                if (strstr($fieldInfo['flags'], 'primary_key') !== false) {
                    if (strlen($primaryKeys) === 0) {
                        $primaryKeys = $fieldInfo['name'];
                    } else {
                        $primaryKeys .= ',' . $fieldInfo['name'];
                    }
                }
            }
            
            if (strlen($primaryKeys) === 0) {
                $sql = "select * from ${tableName}";
            } else {
                $sql = "select * from ${tableName} order by ${primaryKeys}";
            }
            $res = &$conn->getAll($sql, null, DB_FETCHMODE_ASSOC);
            if (PEAR::isError($res)) {
                $result = &$res;
                break;
            }
            $result[$tableName] = &$res;
        }
        
        return $result;
    }
    /**
     * The data of the table is deleted.
     * 
     * @param   array   $tableNames Array of deleted table name.
     * @return  mixed   true.
     *                  DB_Error object when failing in method call.
     * @access  public
     */
    function clearTables($tableNames = array())
    {
        $conn = &$this->_getConnection();
        if (PEAR::isError($conn)) {
            return $conn;
        }
        
        $conn->autoCommit(false);
        $result = &$this->_clearTables(&$conn, $tableNames);
        if ($result === true) {
            $conn->commit();
        } else {
            $conn->rollback();
        }
        $conn->disconnect();
        
        return $result;
    }
    /**
     * The data of the table is deleted.
     * The data of the specified table is deleted by continuously executing the DELETE sql.
     * The method call fails when the execution of the DELETE sql fails even once.
     * 
     * @param   resource    $conn       RDB connection object.
     * @param   array       $tableNames Array of deleted table name.
     * @return  mixed       true.
     *                      DB_Error object when failing in method call.
     * @access  private
     */
    function _clearTables($conn, $tableNames)
    {
        foreach ($tableNames as $tableName) {
            $sql = "delete from ${tableName}";
            $res = &$conn->query($sql);
            if (PEAR::isError($res)) {
                return $res;
            }
        }
        return true;
    }
    /**
     * The data shown by the array is stored in the table. 
     * Please specify the form of the exportTables() function for the array. 
     * The data that exists in the table before data is stored in the table is deleted. 
     * 
     * @param   array   $data   Array of data stored in table.
     * @return  mixed   true.
     *                  DB_Error object when failing in method call.
     * @access  public
     */
    function importTables($data = array())
    {
        $conn = &$this->_getConnection();
        if (PEAR::isError($conn)) {
            return $conn;
        }
        
        $conn->autoCommit(false);
        $result = &$this->_importTables(&$conn, $data);
        if ($result === true) {
            $conn->commit();
        } else {
            $conn->rollback();
        }
        $conn->disconnect();
        
        return $result;
    }
    /**
     * The data shown by the array is stored in the table. 
     * Please specify the form of the exportTables() function for the array. 
     * The data that exists in the table before data is stored in the table is deleted. 
     * 
     * @param   resource    $conn       RDB connection object.
     * @param   array   $data   Array of data stored in table.
     * @return  mixed   true.
     *                  DB_Error object when failing in method call.
     * @access  public
     */
    function _importTables($conn, $data) {
        $tableNames = array();
        foreach ($data as $tableName => $tableData) {
            $tableNames[] = $tableName;
        }
        $result = &$this->_clearTables(&$conn, $tableNames);
        if (PEAR::isError($result)) {
            return $result;
        }
        
        foreach ($data as $tableName => $tableData) {
            foreach ($tableData as $rowData) {
                $sqlFields = '';
                $sqlValues = '';
                $params = array();
                foreach ($rowData as $columnName => $columnValue) {
                    if (strlen($sqlFields) === 0) {
                        $sqlFields = $columnName;
                    } else {
                        $sqlFields .= ',' . $columnName;
                    }
                    if (strlen($sqlValues) === 0) {
                        $sqlValues = '?';
                    } else {
                        $sqlValues .= ',?';
                    }
                    $params[] = $columnValue;
                }
                $sql = "insert into ${tableName} (${sqlFields}) values (${sqlValues})";
                $result = &$conn->query($sql, $params);
                if (PEAR::isError($result)) {
                    return $result;
                }
            }
        }
        return true;
    }
    function _getConnection()
    {
        $conn = &DB::connect($this->dsn);
        return $conn;
    }
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */

?>
