<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Not Predicate
 * (based on org.apache.commons.collections.functors.NotPredicate)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: NotPredicate.php 276 2008-03-30 08:49:34Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/IllegalArgumentException.php';
require_once 'Commons/Cols/Functors/PredicateDecorator.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Lang::IllegalArgumentException;
use Commons::Cols::Functors::PredicateDecorator;
use Commons::IO::Serializable;
*/

/**
 * NotPredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
final class Commons_Cols_Functors_NotPredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Functors_PredicateDecorator, Commons_IO_Serializable {

	/**
	 * The predicate to decorate
	 *
	 * @var Commons_Cols_Predicate
	 */
	private $iPredicate = null;
	
	
	/**
	 * Factory method to create the equal predicate.
	 *
	 * @param Commons_Cols_Predicate $predicate
	 * @return Commons_Cols_Predicate
	 * @throws Commons_Lang_IllegalArgumentException if the predicate is null
	 */
	public static function getInstance(Commons_Cols_Predicate $predicate) {
		if (is_null($predicate)) {
			throw new Commons_Lang_IllegalArgumentException('Predicate must not be null');
		}
		
		return new self($predicate);
	}
	
	
	/**
	 * Constructor
	 *
	 * @param Commons_Cols_Predicate $predicate
	 */
	public function Commons_Cols_Functors_NotPredicate(Commons_Cols_Predicate $predicate) {
		parent::__construct();
		$this->iPredicate = $predicate;
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate returning the opposite to the stored predicate.
	 *
	 * @param object $object
	 * @return bool true if the stored predicate returns false.
	 */
	public function evaluate($object) {
		return !($this->iPredicate->evaluate($object));
	}

	
	/**
	 * Gets the predicate being decorated.
	 *
	 * @return array<Commons_Cols_Predicate>
	 */
	public function getPredicates() {
		return array($this->iPredicate);
	}
		
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>