<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * System Utilities
 * (based on org.apache.commons.lang.SystemUtils)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: SystemUtils.php 177 2008-01-29 13:42:27Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::StringUtils;
*/

/**
 * SystemUtils
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_SystemUtils extends Commons_Lang_Object {

	private static $_instance = null;
	
	private static $IS_OS_UNIX = null;
	
	private static $IS_OS_WINDOWS = null;
	
	private static $IS_OS_MAC = null;
	
	private static $UNIX_OS_NAMES = array(
		'AIX', 'Darwin', 'OSX', 'FreeBSD', 'HP-UX', 'Linux', 'LINUX', 'SunOS');
	
	private static $FILE_SEPARATOR = null;
	
	private static $LINE_SEPARATOR = null;
	
	private static $PATH_SEPARATOR = null;
	
	private static $OS_NAME = null;
	
	
	/**
	 * Constructor for use as bean.
	 */
	public function Commons_Lang_SystemUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	public static function getFileSeparator() {
		if (is_null(self::$FILE_SEPARATOR)) {
			if (defined('DIRECTORY_SEPARATOR')) {
				self::$FILE_SEPARATOR = DIRECTORY_SEPARATOR;
			}
			elseif (self::isOSUnix()) {
				self::$FILE_SEPARATOR = '/';
			}
			elseif (self::isOSWindows()) {
				self::$FILE_SEPARATOR = '\\';
			}
			else {
				self::$FILE_SEPARATOR = '/';
			}
		}
		
		return self::$FILE_SEPARATOR;
	}
	
	
	public static function getLineSeparator() {
		if (is_null(self::$LINE_SEPARATOR)) {
			if (defined('PHP_EOL')) {
				self::$LINE_SEPARATOR = PHP_EOL;
			}
			elseif (self::isOSUnix()) {
				self::$LINE_SEPARATOR = '\n';
			}
			elseif (self::isOSWindows()) {
				self::$LINE_SEPARATOR = '\r\n';
			}
			else {
				self::$LINE_SEPARATOR = 'n';
			}
		}
		
		return self::$LINE_SEPARATOR;
	}
	
	
	public static function getPathSeparator() {
		if (is_null(self::$PATH_SEPARATOR)) {
			if (defined('PATH_SEPARATOR')) {
				self::$PATH_SEPARATOR = PATH_SEPARATOR;
			}
			elseif (self::isOSUnix()) {
				self::$PATH_SEPARATOR = ':';
			}
			elseif (self::isOSWindows()) {
				self::$PATH_SEPARATOR = ';';
			}
			else {
				self::$PATH_SEPARATOR = ':';
			}
		}
		
		return self::$PATH_SEPARATOR;
	}
	
	
	public static function getOSName() {
		if (is_null(self::$OS_NAME)) {
			if (defined('PHP_OS')) {
				self::$OS_NAME = PHP_OS;
			}
			else {
				self::$OS_NAME = 'UNKNOWN';
			}
		}
		
		return self::$OS_NAME;
	}
	
	
	public static function isOSUnix() {
		if (is_null(self::$IS_OS_UNIX)) {
			self::$IS_OS_UNIX = in_array(self::getOSName(), self::$UNIX_OS_NAMES, true);
		}
		
		return self::$IS_OS_UNIX;
	}
	
	
	public static function isOSWindows() {
		if (is_null(self::$IS_OS_WINDOWS)) {
			self::$IS_OS_WINDOWS = self::getOSMatches('WIN');
		}
		
		return self::$IS_OS_WINDOWS;
	}

	
	private static function getOSMatches($osNamePrefix) {
		return Commons_Lang_StringUtils::startsWith(self::getOSName(), $osNamePrefix);
	}
	
	
	public static function getUnixOSNames() {
		return self::$UNIX_OS_NAMES;	
	}
	
	
	protected static function init4Test() {
		self::$IS_OS_UNIX = null;
		self::$IS_OS_WINDOWS = null;
		self::$IS_OS_MAC = null;
		self::$LINE_SEPARATOR = null;
		self::$PATH_SEPARATOR = null;
		self::$OS_NAME = null;
	}
	
	
	public static function setOSName4Test($osName) {
		self::init4Test();
		self::$OS_NAME = $osName;		
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>