<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Properties
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: Properties.php 296 2008-04-17 13:07:20Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Util;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/SystemUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::SystemUtils;
*/

/**
 * Properties
 *
 *
 * @category   PHP
 * @package    Commons.Util
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Util_Properties extends Commons_Lang_Object {

	protected $defaults = null;
	

	public function Commons_Util_Properties(Commons_Util_Properties $defaults = null) {
		if (!is_null($defaults)) {
			$this->defaults = $defaults;
		}
	}
	
	
	public function __destruct() {
	}
	
	
	public function load($inStream) {
		while (!feof($inStream)) {
			$line = trim(fgets($inStream));
			if ($line !== '' && $line[0] !== '#') {
				$pos = strpos($line, '=');
				if ($pos > 1) {
					$key = trim(substr($line, 0, $pos - 0));
					$value = trim(substr($line, $pos + 1), " \"\t\n\r\0\x0B");
					$this->setProperty($key, $value);
				}
			}
		}
	}
	
	
	public function propertyNames() {
		return array_keys($this->getProperties());	
	}
	
	
	public function getProperty($key, $defaultValue = null) {
		$value = parent::getProperty($key);
		
		return is_null($value) ? $defaultValue : $value;
	}
	
	
	public function setProperty($key, $value) {
		parent::setProperty($key, $value);
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>